/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import com.ibm.icu.lang.UCharacter;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;
import java.util.Vector;

public class ToGetUnicodeNames
extends Transformation
implements Cloneable {
    private static final String INFO = "Get Unicode Names";

    public static Vector<LexItem> Mutate(LexItem in, String startTag, String endTag, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToGetUnicodeNames.GetUnicodeNames(in, startTag, endTag, detailsFlag, mutateFlag);
        return out;
    }

    public static String GetUnicodeName(char inChar, String startTag, String endTag) {
        String outStr = startTag + UCharacter.getName(inChar) + endTag;
        return outStr;
    }

    public static String GetUnicodeName(String inStr, String startTag, String endTag) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            if (UnicodeUtil.IsAsciiChar(curChar)) {
                buf.append(curChar);
                continue;
            }
            buf.append(ToGetUnicodeNames.GetUnicodeName(curChar, startTag, endTag));
        }
        return buf.toString();
    }

    public static char GetCharFromUnicodeName(String unicodeName, String startTag, String endTag) {
        if (unicodeName == null) {
            return '\uffff';
        }
        if (ToGetUnicodeNames.IsLegalUnicodeNameFormat(unicodeName, startTag, endTag)) {
            unicodeName = ToGetUnicodeNames.GetUnicodeNameWithoutTag(unicodeName, startTag, endTag);
            char out = (char)UCharacter.getCharFromExtendedName(unicodeName);
            return out;
        }
        return '\uffff';
    }

    public static void main(String[] args) {
        String testStr = "\u00a9 and \u00b5";
        Configuration conf = new Configuration("data.config.lvg", true);
        String startTag = conf.GetConfiguration("START_TAG");
        String endTag = conf.GetConfiguration("END_TAG");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToGetUnicodeNames.Mutate(in, startTag, endTag, true, true);
        ToGetUnicodeNames.PrintResults(in, outs);
    }

    private static Vector<LexItem> GetUnicodeNames(LexItem in, String startTag, String endTag, boolean detailsFlag, boolean mutateFlag) {
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = new String();
        }
        String inStr = in.GetSourceTerm();
        String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            if (UnicodeUtil.IsAsciiChar(curChar)) {
                buf.append(curChar);
            } else {
                buf.append(ToGetUnicodeNames.GetUnicodeName(curChar, startTag, endTag));
            }
            if (!mutateFlag) continue;
            mutate = mutate + UnicodeUtil.GetUnicodeInfoXNB(curChar) + fs;
        }
        String term = buf.toString();
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToGetUnicodeNames.UpdateLexItem(in, term, 53, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    private static boolean IsLegalUnicodeNameFormat(String inStr, String startTag, String endTag) {
        return inStr.length() >= startTag.length() + endTag.length() + 1 && inStr.startsWith(startTag) && inStr.endsWith(endTag);
    }

    private static String GetUnicodeNameWithoutTag(String inStr, String startTag, String endTag) {
        String outStr = inStr.substring(startTag.length(), inStr.length() - endTag.length());
        return outStr;
    }
}

