/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.ToAcronyms;
import gov.nih.nlm.nls.lvg.Flows.ToExpansions;
import gov.nih.nlm.nls.lvg.Flows.ToInflection;
import gov.nih.nlm.nls.lvg.Flows.ToRecursiveDerivations;
import gov.nih.nlm.nls.lvg.Flows.ToRecursiveSynonyms;
import gov.nih.nlm.nls.lvg.Flows.ToSpellingVariants;
import gov.nih.nlm.nls.lvg.Flows.ToUninflectTerm;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.CatInflKey;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.CombineRecords;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.Flow;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Lib.TermCatCatKey;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToFruitfulVariants
extends Transformation
implements Cloneable {
    private static final String INFO = "Generate Fruitful Variants";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trieI, RamTrie trieD, boolean detailsFlag, boolean mutateFlag) throws SQLException {
        Vector<LexItem> originalSet = ToFruitfulVariants.GetNoOperationSet(in, conn, trieI, detailsFlag, false);
        Vector<LexItem> variantSet = ToFruitfulVariants.GetVariantSet(in, conn, trieI, trieD, detailsFlag);
        Vector<LexItem> sivSet = ToFruitfulVariants.GetSpellingAndInflections(variantSet, conn, trieI, detailsFlag, 2);
        originalSet = ToFruitfulVariants.AddToVariantList(originalSet, sivSet);
        String flowName = Flow.GetBitName(42, 1);
        Vector<LexItem> outs = ToFruitfulVariants.GetFinalSet(originalSet, flowName, mutateFlag);
        return outs;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToFruitfulVariants.GetTestStr(args, "neurological");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        int minTrieStemLength = Integer.parseInt(conf.GetConfiguration("DIR_TRIE_STEM_LENGTH"));
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            RamTrie trieI = new RamTrie(true, minTermLen, lvgDir, 0);
            RamTrie trieD = new RamTrie(false, minTermLen, lvgDir, minTrieStemLength);
            if (conn != null) {
                outs = ToFruitfulVariants.Mutate(in, conn, trieI, trieD, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToFruitfulVariants.PrintResults(in, outs);
    }

    static Vector<LexItem> GetSpellingAndInflections(Vector<LexItem> ins, Connection conn, RamTrie trieI, boolean detailsFlag, int restrictFlag) {
        Vector<LexItem> list7 = ToFruitfulVariants.GetSpellingVariants(ins, conn, detailsFlag);
        list7 = ToFruitfulVariants.AddToVariantList(list7, ins);
        Vector<LexItem> list8 = ToFruitfulVariants.GetInflections(list7, conn, trieI, detailsFlag, restrictFlag);
        list7 = ToFruitfulVariants.AddToVariantList(list7, list8);
        return list7;
    }

    static Vector<LexItem> GetFinalSet(Vector<LexItem> ins, String flowName, boolean mutateFlag) {
        Hashtable<TermCatCatKey, LexItem> ht = new Hashtable<TermCatCatKey, LexItem>();
        for (int i = 0; i < ins.size(); ++i) {
            LexItem tempRec = ins.elementAt(i);
            TermCatCatKey tempKey = new TermCatCatKey(tempRec.GetTargetTerm().toLowerCase(), ToFruitfulVariants.GetFirstCategory(tempRec), (int)tempRec.GetTargetCategory().GetValue());
            if (ht.containsKey(tempKey)) {
                int tempDist;
                LexItem existRec = (LexItem)ht.get(tempKey);
                int existDist = ToFruitfulVariants.CalculateDistance(existRec.GetFlowHistory());
                if (existDist <= (tempDist = ToFruitfulVariants.CalculateDistance(tempRec.GetFlowHistory()))) continue;
                ht.remove(tempKey);
                ht.put(tempKey, tempRec);
                continue;
            }
            ht.put(tempKey, tempRec);
        }
        Vector<LexItem> uniqueList = new Vector<LexItem>(ht.values());
        Vector<LexItem> legalList = OutputFilter.GetEnhancedSimpleInflection(uniqueList);
        Vector<LexItem> outs = ToFruitfulVariants.UpdateVariants(legalList, flowName, mutateFlag);
        return outs;
    }

    static Vector<LexItem> GetVariantSet(LexItem in, Connection conn, RamTrie trieI, RamTrie trieD, boolean detailsFlag) throws SQLException {
        Vector<LexItem> bn = ToFruitfulVariants.GetBaseSet(in, conn, trieI, detailsFlag);
        Vector<LexItem> s = ToFruitfulVariants.GetSpellingVariants(bn, conn, detailsFlag);
        Vector<LexItem> A = ToFruitfulVariants.GetAcronyms(s, conn, detailsFlag);
        Vector<LexItem> y = ToFruitfulVariants.GetRecursiveSynonyms(s, conn, detailsFlag);
        Vector<LexItem> list1 = new Vector<LexItem>();
        list1.addAll(s);
        list1 = ToFruitfulVariants.AddToVariantList(list1, A);
        list1 = ToFruitfulVariants.AddToVariantList(list1, y);
        Vector<LexItem> list2 = ToFruitfulVariants.GetRecursiveDerivations(list1, conn, trieD, detailsFlag);
        Vector<LexItem> list3 = ToFruitfulVariants.GetRecursiveSynonyms(list2, conn, detailsFlag);
        Vector<LexItem> list4 = ToFruitfulVariants.GetRecursiveSynonyms(A, conn, detailsFlag);
        Vector<LexItem> list5 = ToFruitfulVariants.GetAcronyms(y, conn, detailsFlag);
        Vector<LexItem> list6 = new Vector<LexItem>();
        list6 = ToFruitfulVariants.AddToVariantList(list6, list1);
        list6 = ToFruitfulVariants.AddToVariantList(list6, list2);
        list6 = ToFruitfulVariants.AddToVariantList(list6, list3);
        list6 = ToFruitfulVariants.AddToVariantList(list6, list4);
        list6 = ToFruitfulVariants.AddToVariantList(list6, list5);
        return list6;
    }

    static Vector<LexItem> GetNoOperationSet(LexItem in, Connection conn, RamTrie trieI, boolean detailsFlag, boolean lexiconOnly) throws SQLException {
        String term = in.GetSourceTerm();
        String details = null;
        if (detailsFlag) {
            details = "No Operation (Retrieve Cat/Infl)";
        }
        String mutate = null;
        Vector<Object> facts = new Vector();
        facts = DbInflection.GetCatInfl(in.GetSourceTerm(), conn);
        Hashtable<CatInflKey, LexItem> ht = new Hashtable<CatInflKey, LexItem>();
        Vector<LexItem> catInfl = new Vector<LexItem>();
        for (int i = 0; i < facts.size(); ++i) {
            InflectionRecord record = (InflectionRecord)facts.elementAt(i);
            if (record.GetInflection() > 255L && (long)record.GetCategory() != Category.ToValue("aux") && (long)record.GetCategory() != Category.ToValue("modal")) continue;
            mutate = Long.toString(record.GetCategory()) + GlobalBehavior.GetInstance().GetFieldSeparator() + Long.toString(record.GetInflection());
            LexItem temp = ToFruitfulVariants.UpdateLexItem(in, term, 15, record.GetCategory(), record.GetInflection(), details, mutate);
            catInfl.addElement(temp);
            CatInflKey tempKey = new CatInflKey((int)temp.GetTargetCategory().GetValue(), temp.GetTargetInflection().GetValue());
            ht.put(tempKey, temp);
        }
        if (!lexiconOnly && catInfl.size() == 0) {
            Vector<CatInfl> rules = trieI.GetCatInflsByRules(term, in.GetSourceCategory().GetValue(), in.GetSourceInflection().GetValue());
            for (int i = 0; i < rules.size(); ++i) {
                CatInfl rec = rules.elementAt(i);
                if (rec.GetInflection() > 255L) continue;
                mutate = Long.toString(rec.GetCategory());
                LexItem temp = ToFruitfulVariants.UpdateLexItem(in, term, 15, rec.GetCategory(), rec.GetInflection(), details, mutate);
                catInfl.addElement(temp);
                CatInflKey tempKey = new CatInflKey((int)temp.GetTargetCategory().GetValue(), temp.GetTargetInflection().GetValue());
                ht.put(tempKey, temp);
            }
        }
        Vector<LexItem> outs = new Vector<LexItem>(ht.values());
        return outs;
    }

    static Vector<LexItem> AddToVariantList(Vector<LexItem> orgList, Vector<LexItem> newList) {
        int i;
        Hashtable<TermCatCatKey, LexItem> ht = new Hashtable<TermCatCatKey, LexItem>(orgList.size() + newList.size());
        for (i = 0; i < orgList.size(); ++i) {
            LexItem curOrg = orgList.elementAt(i);
            TermCatCatKey curOrgKey = new TermCatCatKey(curOrg.GetTargetTerm(), ToFruitfulVariants.GetFirstCategory(curOrg), (int)curOrg.GetTargetCategory().GetValue());
            ht.put(curOrgKey, curOrg);
        }
        for (i = 0; i < newList.size(); ++i) {
            LexItem curNew = newList.elementAt(i);
            TermCatCatKey curNewKey = new TermCatCatKey(curNew.GetTargetTerm(), ToFruitfulVariants.GetFirstCategory(curNew), (int)curNew.GetTargetCategory().GetValue());
            if (ht.containsKey(curNewKey)) {
                int curNewDist;
                LexItem existRec = (LexItem)ht.get(curNewKey);
                int existDist = ToFruitfulVariants.CalculateDistance(existRec.GetFlowHistory());
                if (existDist <= (curNewDist = ToFruitfulVariants.CalculateDistance(curNew.GetFlowHistory()))) continue;
                ht.remove(curNewKey);
                ht.put(curNewKey, curNew);
                continue;
            }
            ht.put(curNewKey, curNew);
        }
        Vector<LexItem> outs = new Vector<LexItem>(ht.values());
        return outs;
    }

    public static int GetFirstCategory(LexItem in) {
        int category = 0;
        if (in.GetMutateInformation() != null) {
            try {
                String delim = "|";
                StringTokenizer buf = new StringTokenizer(in.GetMutateInformation(), delim);
                category = Integer.parseInt(buf.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return category;
    }

    private static Vector<LexItem> GetBaseSet(LexItem in, Connection conn, RamTrie trieI, boolean detailsFlag) throws SQLException {
        String inTerm = in.GetSourceTerm();
        Vector<LexItem> b = new Vector();
        b = ToUninflectTerm.Mutate(in, conn, trieI, detailsFlag, false);
        Vector<LexItem> fb = CombineRecords.Combine(b, 2);
        String noOperationFlowName = Flow.GetBitName(15, 1);
        for (int i = 0; i < fb.size(); ++i) {
            LexItem temp = fb.elementAt(i);
            String curCategory = Long.toString(temp.GetTargetCategory().GetValue());
            String curInflection = Long.toString(temp.GetTargetInflection().GetValue());
            String mutate = curCategory + GlobalBehavior.GetInstance().GetFieldSeparator() + curInflection;
            temp.SetMutateInformation(mutate);
            if (!inTerm.equals(temp.GetTargetTerm())) continue;
            temp.SetFlowHistory(noOperationFlowName);
        }
        return fb;
    }

    private static int CalculateDistance(String history) {
        int dist = 0;
        block5: for (int i = 0; i < history.length(); ++i) {
            switch (history.charAt(i)) {
                case 'b': 
                case 'i': {
                    ++dist;
                    continue block5;
                }
                case 'A': 
                case 'a': 
                case 'y': {
                    dist += 2;
                    continue block5;
                }
                case 'd': {
                    dist += 3;
                    continue block5;
                }
            }
        }
        return dist;
    }

    private static Vector<LexItem> UpdateVariants(Vector<LexItem> outList, String flowName, boolean mutateFlag) {
        Vector<LexItem> outs = new Vector<LexItem>();
        for (int i = 0; i < outList.size(); ++i) {
            LexItem cur = outList.elementAt(i);
            if (mutateFlag) {
                String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
                String flowHis = cur.GetFlowHistory();
                String cat = cur.GetMutateInformation();
                StringBuffer buffer = new StringBuffer();
                buffer.append(cat);
                buffer.append(fs);
                buffer.append(flowHis);
                buffer.append(fs);
                buffer.append(ToFruitfulVariants.CalculateDistance(flowHis));
                buffer.append(fs);
                buffer.append(cur.GetTag());
                buffer.append(fs);
                String mutateInfo = buffer.toString();
                cur.SetMutateInformation(mutateInfo);
            }
            cur.SetFlowHistory(flowName);
            outs.addElement(cur);
        }
        return outs;
    }

    private static Vector<LexItem> GetRecursiveDerivations(Vector<LexItem> ins, Connection conn, RamTrie trieD, boolean detailsFlag) {
        Vector<LexItem> outs = new Vector<LexItem>();
        Vector<LexItem> tempIns = LexItem.TargetsToSources(ins);
        for (int i = 0; i < tempIns.size(); ++i) {
            LexItem curIn = tempIns.elementAt(i);
            Vector<LexItem> derivations = ToRecursiveDerivations.Mutate(curIn, conn, trieD, 1, detailsFlag, false, true);
            ToFruitfulVariants.PassCategory(derivations, curIn.GetMutateInformation());
            outs.addAll(derivations);
        }
        return outs;
    }

    private static Vector<LexItem> GetAcronyms(Vector<LexItem> ins, Connection conn, boolean detailsFlag) {
        Vector<LexItem> outs = new Vector<LexItem>();
        Vector<LexItem> tempIns = LexItem.TargetsToSources(ins);
        for (int i = 0; i < tempIns.size(); ++i) {
            LexItem curIn = tempIns.elementAt(i);
            Vector<LexItem> acronyms = ToAcronyms.Mutate(curIn, conn, detailsFlag, false);
            ToFruitfulVariants.PassCategory(acronyms, curIn.GetMutateInformation());
            outs.addAll(acronyms);
            Vector<LexItem> expansions = ToExpansions.Mutate(curIn, conn, detailsFlag, false);
            ToFruitfulVariants.PassCategory(expansions, curIn.GetMutateInformation());
            outs.addAll(expansions);
        }
        return outs;
    }

    private static void PassCategory(Vector<LexItem> ins, String mutateInfo) {
        for (int i = 0; i < ins.size(); ++i) {
            LexItem cur = ins.elementAt(i);
            cur.SetMutateInformation(mutateInfo);
        }
    }

    private static Vector<LexItem> GetRecursiveSynonyms(Vector<LexItem> ins, Connection conn, boolean detailsFlag) {
        Vector<LexItem> outs = new Vector<LexItem>();
        Vector<LexItem> tempIns = LexItem.TargetsToSources(ins);
        for (int i = 0; i < tempIns.size(); ++i) {
            LexItem curIn = tempIns.elementAt(i);
            Vector<LexItem> rSynonyms = ToRecursiveSynonyms.Mutate(curIn, conn, detailsFlag, false, true);
            ToFruitfulVariants.PassCategory(rSynonyms, curIn.GetMutateInformation());
            outs.addAll(rSynonyms);
        }
        return outs;
    }

    private static Vector<LexItem> GetInflections(Vector<LexItem> ins, Connection conn, RamTrie trieI, boolean detailsFlag, int restrictFlag) {
        Vector<LexItem> outs = new Vector<LexItem>();
        Vector<LexItem> tempIns = LexItem.TargetsToSources(ins);
        for (int i = 0; i < tempIns.size(); ++i) {
            LexItem curIn = tempIns.elementAt(i);
            CatInfl converted = CatInfl.ConvertToBase(new CatInfl(curIn.GetSourceCategory().GetValue(), curIn.GetSourceInflection().GetValue()));
            curIn.SetSourceInflection(converted.GetInflection());
            Vector<LexItem> infls = ToInflection.Mutate(curIn, conn, trieI, restrictFlag, detailsFlag, false);
            ToFruitfulVariants.PassCategory(infls, curIn.GetMutateInformation());
            outs.addAll(infls);
        }
        return outs;
    }

    private static Vector<LexItem> GetSpellingVariants(Vector<LexItem> ins, Connection conn, boolean detailsFlag) {
        int i;
        Vector<LexItem> outs = new Vector<LexItem>();
        Vector<LexItem> tempIns = LexItem.TargetsToSources(ins);
        for (i = 0; i < tempIns.size(); ++i) {
            LexItem curIn = tempIns.elementAt(i);
            Vector<LexItem> sv = ToSpellingVariants.Mutate(curIn, conn, detailsFlag, false);
            ToFruitfulVariants.PassCategory(sv, curIn.GetMutateInformation());
            outs.addAll(sv);
        }
        for (i = 0; i < outs.size(); ++i) {
            LexItem temp = outs.elementAt(i);
            if (!temp.GetSourceTerm().equalsIgnoreCase(temp.GetTargetTerm())) continue;
            String flowHistory = temp.GetFlowHistory();
            int endIndex = flowHistory.length() - 2;
            temp.SetFlowHistory(flowHistory.substring(0, endIndex));
        }
        return outs;
    }
}

