/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.AcronymRecord;
import gov.nih.nlm.nls.lvg.Db.DbAcronym;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Flows.ToStripPunctuation;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.Tag;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToAcronyms
extends Transformation
implements Cloneable {
    private static final String INFO = "Generate Acronyms";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) {
        Vector<AcronymRecord> records = ToAcronyms.GetAcronyms(in.GetSourceTerm(), conn);
        Vector<LexItem> out = new Vector<LexItem>();
        int size = records.size();
        boolean curTagFlag = size == 1;
        Tag tag = new Tag(in.GetTag());
        tag.SetBitFlag(1, curTagFlag);
        String tagStr = curTagFlag ? "Unique" : "NotUnique";
        in.SetTag(tag.GetValue());
        for (int i = 0; i < size; ++i) {
            AcronymRecord record = records.elementAt(i);
            String term = record.GetAcronym();
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = "Generate Acronyms (" + record.GetType() + ")";
            }
            if (mutateFlag) {
                String fs = GlobalBehavior.GetInstance().GetFieldSeparator();
                mutate = record.GetType() + fs + tagStr + fs;
            }
            LexItem temp = ToAcronyms.UpdateLexItem(in, term, 16, -1L, Inflection.GetBitValue(0), details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToAcronyms.GetTestStr(args, "VERY LOW-DENSITY LIPOPROTEIN");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToAcronyms.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToAcronyms.PrintResults(in, outs);
    }

    private static Vector<AcronymRecord> GetAcronyms(String inStr, Connection conn) {
        String strippedStr = ToStripPunctuation.StripPunctuation(inStr);
        String lcStrippedStr = strippedStr.toLowerCase();
        Vector<AcronymRecord> out = new Vector<AcronymRecord>();
        try {
            out = DbAcronym.GetAcronyms(lcStrippedStr, conn);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return out;
    }
}

