/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.opennlp.maxent.encoder;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.opennlp.maxent.encoder.ContextValues;

public class ContextValuesFeaturesEncoder
implements FeaturesEncoder<ContextValues> {
    private static final long serialVersionUID = -1709923235891820441L;

    public ContextValues encodeAll(Iterable<Feature> featuresIterable) throws CleartkEncoderException {
        Collection features = (Collection)featuresIterable;
        String[] context = new String[features.size()];
        float[] values = new float[features.size()];
        int i = -1;
        for (Feature feature : features) {
            ++i;
            if (feature.getValue() instanceof Number) {
                context[i] = feature.getName();
                values[i] = ((Number)feature.getValue()).floatValue();
                continue;
            }
            if (feature.getValue() instanceof Boolean) {
                context[i] = feature.getName();
                values[i] = (Boolean)feature.getValue() != false ? 1.0f : 0.0f;
                continue;
            }
            Object value = feature.getValue();
            context[i] = Feature.createName((String[])new String[]{feature.getName(), value == null ? null : value.toString()});
            values[i] = 1.0f;
        }
        return new ContextValues(context, values);
    }

    public void finalizeFeatureSet(File outputDirectory) throws IOException {
    }
}

