/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.drugner.fsm.machines.elements;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.openai.util.fsm.AnyCondition;
import net.openai.util.fsm.Condition;
import net.openai.util.fsm.Machine;
import net.openai.util.fsm.State;
import org.apache.ctakes.core.fsm.condition.IntegerValueCondition;
import org.apache.ctakes.core.fsm.condition.NumberCondition;
import org.apache.ctakes.core.fsm.condition.PunctuationValueCondition;
import org.apache.ctakes.core.fsm.state.NamedState;
import org.apache.ctakes.core.fsm.token.BaseToken;
import org.apache.ctakes.drugner.fsm.output.util.DecimalStrengthToken;

public class DecimalStrengthFSM {
    private Set iv_machineSet = new HashSet();

    public DecimalStrengthFSM() {
        this.iv_machineSet.add(this.getDecimalStrengthMachine());
    }

    private Machine getDecimalStrengthMachine() {
        NamedState startState = new NamedState("START");
        NamedState endState = new NamedState("END");
        endState.setEndStateFlag(true);
        Machine m = new Machine((State)startState);
        NamedState zeroNumState = new NamedState("ZERO_NUM");
        NamedState fractionTextState = new NamedState("NUMERATOR_TEXT");
        NamedState dashState = new NamedState("DASH");
        startState.addTransition((Condition)new IntegerValueCondition(0), (State)zeroNumState);
        startState.addTransition((Condition)new AnyCondition(), (State)startState);
        zeroNumState.addTransition((Condition)new PunctuationValueCondition('.'), (State)fractionTextState);
        zeroNumState.addTransition((Condition)new AnyCondition(), (State)startState);
        fractionTextState.addTransition((Condition)new NumberCondition(), (State)dashState);
        fractionTextState.addTransition((Condition)new AnyCondition(), (State)startState);
        dashState.addTransition((Condition)new PunctuationValueCondition('-'), (State)endState);
        dashState.addTransition((Condition)new AnyCondition(), (State)startState);
        endState.addTransition((Condition)new AnyCondition(), (State)startState);
        return m;
    }

    public Set execute(List tokens) throws Exception {
        HashSet<DecimalStrengthToken> fractionSet = new HashSet<DecimalStrengthToken>();
        HashMap<Machine, Integer> tokenStartMap = new HashMap<Machine, Integer>();
        for (int i = 0; i < tokens.size(); ++i) {
            BaseToken token = (BaseToken)tokens.get(i);
            for (Machine fsm : this.iv_machineSet) {
                int tokenStartIndex;
                fsm.input((Object)token);
                State currentState = fsm.getCurrentState();
                if (currentState.getStartStateFlag()) {
                    tokenStartMap.put(fsm, i);
                }
                if (!currentState.getEndStateFlag()) continue;
                Object o = tokenStartMap.get(fsm);
                if (o == null) {
                    tokenStartIndex = 0;
                } else {
                    tokenStartIndex = (Integer)o;
                    ++tokenStartIndex;
                }
                BaseToken startToken = (BaseToken)tokens.get(tokenStartIndex);
                BaseToken endToken = token;
                DecimalStrengthToken fractionToken = new DecimalStrengthToken(startToken.getStartOffset(), endToken.getEndOffset());
                fractionSet.add(fractionToken);
                fsm.reset();
            }
        }
        tokenStartMap.clear();
        for (Machine fsm : this.iv_machineSet) {
            fsm.reset();
        }
        return fractionSet;
    }
}

