/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.necontexts.status;

import java.util.List;
import java.util.Set;
import org.apache.ctakes.core.fsm.machine.StatusIndicatorFSM;
import org.apache.ctakes.core.fsm.output.StatusIndicator;
import org.apache.ctakes.core.fsm.token.TextToken;
import org.apache.ctakes.necontexts.ContextAnalyzer;
import org.apache.ctakes.necontexts.ContextHit;
import org.apache.ctakes.necontexts.NamedEntityContextAnalyzer;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.tcas.Annotation;

public class StatusContextAnalyzer
extends NamedEntityContextAnalyzer
implements ContextAnalyzer {
    public static final String CTX_HIT_KEY_STATUS_TYPE = "STATUS_TYPE";
    private StatusIndicatorFSM _statusIndicatorFSM = new StatusIndicatorFSM();

    @Override
    public ContextHit analyzeContext(List<? extends Annotation> tokenList, int scope) throws AnalysisEngineProcessException {
        List<TextToken> fsmTokenList = this.wrapAsFsmTokens(tokenList);
        try {
            Set s = this._statusIndicatorFSM.execute(fsmTokenList);
            if (s.size() > 0) {
                StatusIndicator finalSi = null;
                for (StatusIndicator si : s) {
                    if (finalSi == null) {
                        finalSi = si;
                        continue;
                    }
                    if (si.getStatus() == 2 && finalSi.getStatus() == 1) {
                        finalSi = si;
                        continue;
                    }
                    if (scope == 1 && si.getEndOffset() > finalSi.getEndOffset()) {
                        finalSi = si;
                        continue;
                    }
                    if (scope != 3 || si.getStartOffset() >= finalSi.getStartOffset()) continue;
                    finalSi = si;
                }
                ContextHit ctxHit = new ContextHit(finalSi.getStartOffset(), finalSi.getEndOffset());
                ctxHit.addMetaData(CTX_HIT_KEY_STATUS_TYPE, new Integer(finalSi.getStatus()));
                return ctxHit;
            }
            return null;
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

