/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.pipelines;

import com.google.common.collect.ObjectArrays;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.ModifierExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.eval.ModifierExtractorEvaluation;
import org.apache.ctakes.relationextractor.eval.ParameterSettings;
import org.apache.ctakes.relationextractor.eval.RelationExtractorEvaluation;
import org.apache.ctakes.relationextractor.eval.SHARPXMI;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.DegreeOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.xml.sax.SAXException;

public class RelationExtractorTrain {
    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        if (!options.getResourcesDirectory().exists()) {
            throw new IllegalArgumentException("directory not found: " + options.getResourcesDirectory().getCanonicalPath());
        }
        if (!options.getDescriptorsDirectory().exists()) {
            throw new IllegalArgumentException("directory not found: " + options.getDescriptorsDirectory().getCanonicalPath());
        }
        File resourcesDirectory = options.getResourcesDirectory();
        File descriptorsDirectory = options.getDescriptorsDirectory();
        File preprocessDescFile = new File(descriptorsDirectory, "RelationExtractorPreprocessor.xml");
        if (!preprocessDescFile.exists()) {
            throw new IllegalArgumentException("Can't create aggregate without " + preprocessDescFile.getCanonicalPath());
        }
        List<File> trainFiles = SHARPXMI.getAllTextFiles(options.getBatchesDirectory());
        trainFiles = SHARPXMI.toXMIFiles(options, trainFiles);
        String modelPathPrefix = "org/apache/ctakes/relationextractor/models/";
        String modifierModelPath = modelPathPrefix + "modifier_extractor";
        String degreeOfModelPath = modelPathPrefix + "degree_of";
        String locationOfModelPath = modelPathPrefix + "location_of";
        System.err.println("Training modifier extractor");
        File modifierTrainDirectory = new File(resourcesDirectory, modifierModelPath);
        ModifierExtractorEvaluation evaluation = new ModifierExtractorEvaluation(modifierTrainDirectory, ModifierExtractorEvaluation.BEST_PARAMETERS);
        evaluation.train(evaluation.getCollectionReader(trainFiles), modifierTrainDirectory);
        AnalysisEngineDescription modifierExtractorDesc = AnalysisEngineFactory.createEngineDescription(ModifierExtractorAnnotator.class, (Object[])new Object[]{"classifierJarPath", "/" + modifierModelPath + "/model.jar"});
        RelationExtractorTrain.writeDesc(descriptorsDirectory, ModifierExtractorAnnotator.class, modifierExtractorDesc);
        System.err.println("Training degree_of extractor");
        AnalysisEngineDescription degreeOfRelationExtractorDesc = RelationExtractorTrain.trainRelationExtractor(resourcesDirectory, degreeOfModelPath, trainFiles, DegreeOfTextRelation.class, descriptorsDirectory);
        System.err.println("Training location_of extractor");
        AnalysisEngineDescription locationOfRelationExtractorDesc = RelationExtractorTrain.trainRelationExtractor(resourcesDirectory, locationOfModelPath, trainFiles, LocationOfTextRelation.class, descriptorsDirectory);
        System.err.println("Assembling relation extraction aggregate");
        AggregateBuilder builder = new AggregateBuilder();
        XMLParser parser = UIMAFramework.getXMLParser();
        XMLInputSource source = new XMLInputSource(preprocessDescFile);
        builder.add(parser.parseAnalysisEngineDescription(source), new String[0]);
        builder.add(modifierExtractorDesc, new String[0]);
        builder.add(degreeOfRelationExtractorDesc, new String[0]);
        builder.add(locationOfRelationExtractorDesc, new String[0]);
        AnalysisEngineDescription aggregateDescription = builder.createAggregateDescription();
        RelationExtractorTrain.writeDesc(descriptorsDirectory, "RelationExtractorAggregate", aggregateDescription);
        for (File modelDir : new File(resourcesDirectory, modelPathPrefix).listFiles()) {
            File modelFile = JarClassifierBuilder.getModelJarFile((File)modelDir);
            for (File file : modelDir.listFiles()) {
                if (file.equals(modelFile)) continue;
                file.delete();
            }
        }
    }

    private static AnalysisEngineDescription trainRelationExtractor(File resourcesDirectory, String modelPath, List<File> trainFiles, Class<? extends BinaryTextRelation> relationClass, File descriptorsDirectory) throws Exception {
        Class<? extends RelationExtractorAnnotator> annotatorClass = RelationExtractorEvaluation.ANNOTATOR_CLASSES.get(relationClass);
        ParameterSettings params = RelationExtractorEvaluation.BEST_PARAMETERS.get(relationClass);
        File trainDirectory = new File(resourcesDirectory, modelPath);
        RelationExtractorEvaluation evaluation = new RelationExtractorEvaluation(trainDirectory, relationClass, annotatorClass, params);
        evaluation.train(evaluation.getCollectionReader(trainFiles), trainDirectory);
        Object[] pathParameters = new Object[]{"classifierJarPath", "/" + modelPath + "/model.jar"};
        AnalysisEngineDescription relationExtractorDescription = AnalysisEngineFactory.createEngineDescription(annotatorClass, (Object[])ObjectArrays.concat((Object[])params.configurationParameters, (Object[])pathParameters, Object.class));
        RelationExtractorTrain.writeDesc(descriptorsDirectory, annotatorClass, relationExtractorDescription);
        return relationExtractorDescription;
    }

    private static void writeDesc(File descDir, Class<?> annotatorClass, AnalysisEngineDescription desc) throws SAXException, IOException {
        desc.getAnalysisEngineMetaData().setTypeSystem(TypeSystemDescriptionFactory.createTypeSystemDescription((String[])new String[]{"org.apache.ctakes.typesystem.types.TypeSystem"}));
        RelationExtractorTrain.writeDesc(descDir, annotatorClass.getSimpleName(), desc);
    }

    private static void writeDesc(File descDir, String name, AnalysisEngineDescription desc) throws SAXException, IOException {
        desc.getMetaData().setName(name);
        File descFile = new File(descDir, name + ".xml");
        System.err.println("Writing description to " + descFile);
        FileOutputStream output = new FileOutputStream(descFile);
        desc.toXML((OutputStream)output);
        output.close();
    }

    static interface Options
    extends RelationExtractorEvaluation.Options {
        @Option(longName={"resources-dir"}, defaultValue={"../ctakes-relation-extractor-res/src/main/resources"}, description="the directory where resources (e.g. models) should be written")
        public File getResourcesDirectory();

        @Option(longName={"descriptors-dir"}, defaultValue={"desc/analysis_engine"}, description="the directory where descriptors should be written")
        public File getDescriptorsDirectory();
    }
}

