/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.knowtator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.relationextractor.knowtator.ArgumentInfo;
import org.apache.ctakes.relationextractor.knowtator.RelationInfo;
import org.apache.ctakes.relationextractor.knowtator.Span;
import org.jdom.Document;
import org.jdom.Element;

public class XMLReader {
    public static HashMap<String, ArrayList<Span>> getEntityMentions(Document document) {
        HashMap<String, ArrayList<Span>> entityMentions = new HashMap<String, ArrayList<Span>>();
        Element elementRoot = document.getRootElement();
        List annotations = elementRoot.getChildren("annotation");
        for (int i = 0; i < annotations.size(); ++i) {
            Element elementAnnotation = (Element)annotations.get(i);
            List elementSpans = elementAnnotation.getChildren("span");
            if (elementSpans.size() == 0) continue;
            ArrayList<Span> spans = new ArrayList<Span>();
            for (int j = 0; j < elementSpans.size(); ++j) {
                Element elementSpan = (Element)elementSpans.get(j);
                String start = elementSpan.getAttributeValue("start");
                String end = elementSpan.getAttributeValue("end");
                Span span = new Span(Integer.parseInt(start), Integer.parseInt(end));
                spans.add(span);
            }
            String mentionId = elementAnnotation.getChild("mention").getAttributeValue("id");
            entityMentions.put(mentionId, spans);
        }
        return entityMentions;
    }

    public static HashMap<String, String> getEntityTypes(Document document) {
        HashMap<String, String> entityTypes = new HashMap<String, String>();
        Element root = document.getRootElement();
        List classMentions = root.getChildren("classMention");
        for (int i = 0; i < classMentions.size(); ++i) {
            Element classMention = (Element)classMentions.get(i);
            String id = classMention.getAttributeValue("id");
            String cl = classMention.getChildText("mentionClass");
            entityTypes.put(id, cl);
        }
        return entityTypes;
    }

    public static ArrayList<RelationInfo> getRelations(Document document) {
        ArrayList<RelationInfo> relations = new ArrayList<RelationInfo>();
        Element root = document.getRootElement();
        HashMap<String, ArgumentInfo> hashComplexSlotMentions = new HashMap<String, ArgumentInfo>();
        List complexSlotMentions = root.getChildren("complexSlotMention");
        for (int i = 0; i < complexSlotMentions.size(); ++i) {
            Element complexSlotMention = (Element)complexSlotMentions.get(i);
            String id = complexSlotMention.getAttributeValue("id");
            String value = complexSlotMention.getChild("complexSlotMentionValue").getAttributeValue("value");
            String role = complexSlotMention.getChild("mentionSlot").getAttributeValue("id");
            hashComplexSlotMentions.put(id, new ArgumentInfo(value, XMLReader.normalizeRoleName(role)));
        }
        List classMentions = root.getChildren("classMention");
        for (int i = 0; i < classMentions.size(); ++i) {
            Element classMention = (Element)classMentions.get(i);
            List hasSlotMentions = classMention.getChildren("hasSlotMention");
            if (hasSlotMentions.size() < 2) continue;
            String relationType = classMention.getChildText("mentionClass");
            XMLReader.addRelation(relations, hasSlotMentions, hashComplexSlotMentions, relationType);
        }
        return relations;
    }

    private static void addRelation(ArrayList<RelationInfo> relations, List<?> hasSlotMentions, HashMap<String, ArgumentInfo> hashComplexSlotMentions, String relationType) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < hasSlotMentions.size(); ++i) {
            String role;
            String id = ((Element)hasSlotMentions.get(i)).getAttributeValue("id");
            if (!hashComplexSlotMentions.containsKey(id) || !(role = hashComplexSlotMentions.get((Object)id).role).equals("Argument") && !role.equals("Related_to")) continue;
            ids.add(id);
        }
        if (ids.size() != 2) {
            return;
        }
        String id1 = hashComplexSlotMentions.get(ids.get((int)0)).value;
        String role1 = hashComplexSlotMentions.get(ids.get((int)0)).role;
        String id2 = hashComplexSlotMentions.get(ids.get((int)1)).value;
        String role2 = hashComplexSlotMentions.get(ids.get((int)1)).role;
        if (role1.equals("Argument") && role2.equals("Related_to")) {
            relations.add(new RelationInfo(id1, id2, role1, role2, relationType));
        } else if (role2.equals("Argument") && role1.equals("Related_to")) {
            relations.add(new RelationInfo(id2, id1, role2, role1, relationType));
        } else {
            throw new RuntimeException(String.format("Unexpected roles: %s %s", role1, role2));
        }
    }

    private static String normalizeRoleName(String role) {
        if (role.equals("Argument_CU")) {
            return "Argument";
        }
        if (role.equals("Related_to_CU")) {
            return "Related_to";
        }
        return role;
    }
}

