/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import edu.mit.jwi.Dictionary;
import edu.mit.jwi.IDictionary;
import edu.mit.jwi.item.IIndexWord;
import edu.mit.jwi.item.IPointer;
import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.IWord;
import edu.mit.jwi.item.IWordID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Pointer;
import edu.mit.jwi.morph.WordnetStemmer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class WordNetUtils {
    public static final String wordNetPath = "/usr/share/wordnet";

    public static String getHeadWord(String s) {
        String[] elements = s.split(" ");
        return elements[elements.length - 1];
    }

    public static IDictionary getDictionary() throws IOException {
        URL url = new URL("file", null, wordNetPath);
        Dictionary iDictionary = new Dictionary(url);
        iDictionary.open();
        return iDictionary;
    }

    public static List<String> getStems(String word, String posTag, IDictionary iDictionary) {
        POS pos = POS.getPartOfSpeech((char)posTag.charAt(0));
        if (pos == null) {
            return new ArrayList<String>();
        }
        WordnetStemmer wordnetStemmer = new WordnetStemmer(iDictionary);
        List stems = wordnetStemmer.findStems(word, pos);
        return stems;
    }

    public static HashSet<String> getSynonyms(IDictionary iDictionary, String word, String posTag, boolean firstSenseOnly) {
        HashSet<String> synonyms = new HashSet<String>();
        POS pos = POS.getPartOfSpeech((char)posTag.charAt(0));
        if (pos == null) {
            return synonyms;
        }
        IIndexWord iIndexWord = iDictionary.getIndexWord(word, pos);
        if (iIndexWord == null) {
            return synonyms;
        }
        for (IWordID iWordId : iIndexWord.getWordIDs()) {
            IWord iWord = iDictionary.getWord(iWordId);
            ISynset iSynset = iWord.getSynset();
            for (IWord synsetMember : iSynset.getWords()) {
                synonyms.add(synsetMember.getLemma());
            }
            if (!firstSenseOnly) continue;
            break;
        }
        return synonyms;
    }

    public static HashSet<String> getHypernyms(IDictionary dict, String word, String posTag, boolean firstSenseOnly) {
        HashSet<String> hypernyms = new HashSet<String>();
        POS pos = POS.getPartOfSpeech((char)posTag.charAt(0));
        if (pos == null) {
            return hypernyms;
        }
        IIndexWord iIndexWord = dict.getIndexWord(word, pos);
        if (iIndexWord == null) {
            return hypernyms;
        }
        for (IWordID iWordId : iIndexWord.getWordIDs()) {
            IWord iWord1 = dict.getWord(iWordId);
            ISynset iSynset = iWord1.getSynset();
            for (ISynsetID iSynsetId : iSynset.getRelatedSynsets((IPointer)Pointer.HYPERNYM)) {
                List iWords = dict.getSynset(iSynsetId).getWords();
                for (IWord iWord2 : iWords) {
                    String lemma = iWord2.getLemma();
                    hypernyms.add(lemma.replace(' ', '_'));
                }
            }
            if (!firstSenseOnly) continue;
            break;
        }
        return hypernyms;
    }

    public static HashSet<String> getHyperHypernyms(IDictionary dict, String word, String posTag, boolean firstSenseOnly) {
        HashSet<String> hypernyms = new HashSet<String>();
        POS pos = POS.getPartOfSpeech((char)posTag.charAt(0));
        if (pos == null) {
            return hypernyms;
        }
        IIndexWord iIndexWord = dict.getIndexWord(word, pos);
        if (iIndexWord == null) {
            return hypernyms;
        }
        for (IWordID iWordId : iIndexWord.getWordIDs()) {
            IWord iWord1 = dict.getWord(iWordId);
            ISynset iSynset = iWord1.getSynset();
            for (ISynsetID iSynsetId1 : iSynset.getRelatedSynsets((IPointer)Pointer.HYPERNYM)) {
                for (ISynsetID iSynsetId2 : dict.getSynset(iSynsetId1).getRelatedSynsets((IPointer)Pointer.HYPERNYM)) {
                    List iWords = dict.getSynset(iSynsetId2).getWords();
                    for (IWord iWord2 : iWords) {
                        String lemma = iWord2.getLemma();
                        hypernyms.add(lemma.replace(' ', '_'));
                    }
                }
            }
            if (!firstSenseOnly) continue;
            break;
        }
        return hypernyms;
    }
}

