/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.features;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.ctakes.relationextractor.ae.features.DependencyParseUtils;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

public class DependencyPathFeaturesExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    @Override
    public List<Feature> extract(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        ConllDependencyNode node1 = DependencyParseUtils.findAnnotationHead(jCas, (Annotation)arg1);
        ConllDependencyNode node2 = DependencyParseUtils.findAnnotationHead(jCas, (Annotation)arg2);
        if (node1 == null || node2 == null) {
            return features;
        }
        List<LinkedList<ConllDependencyNode>> paths = DependencyParseUtils.getPathsToCommonAncestor(node1, node2);
        LinkedList<ConllDependencyNode> path1 = paths.get(0);
        LinkedList<ConllDependencyNode> path2 = paths.get(1);
        features.add(new Feature("DEPENDENCY_PATH_MEAN_DISTANCE_TO_COMMON_ANCESTOR", (Object)((double)(path1.size() + path2.size()) / 2.0)));
        features.add(new Feature("DEPENDENCY_PATH_MAX_DISTANCE_TO_COMMON_ANCESTOR", (Object)Math.max(path1.size(), path2.size())));
        features.add(new Feature("DEPENDENCY_PATH_MIN_DISTANCE_TO_COMMON_ANCESTOR", (Object)Math.min(path1.size(), path2.size())));
        LinkedList<ConllDependencyNode> node1ToNode2Path = DependencyParseUtils.getPathBetweenNodes(node1, node2);
        features.add(new Feature("DEPENDENCY_PATH", (Object)DependencyParseUtils.pathToString(node1ToNode2Path)));
        return features;
    }
}

