/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.postagger;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.TypePrioritiesFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;

@PipeBitInfo(name="Part of Speech Tagger", description="Annotate Parts of Speech.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN})
public class POSTagger
extends JCasAnnotator_ImplBase {
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final String POS_MODEL_FILE_PARAM = "PosModelFile";
    public static final String PARAM_POS_MODEL_FILE = "PosModelFile";
    @ConfigurationParameter(name="PosModelFile", mandatory=false, defaultValue={"org/apache/ctakes/postagger/models/mayo-pos.zip"}, description="Model file for OpenNLP POS tagger")
    private String posModelPath;
    private POSTaggerME tagger;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        this.logger.info((Object)("POS tagger model file: " + this.posModelPath));
        try (InputStream fis = FileLocator.getAsStream((String)this.posModelPath);){
            POSModel modelFile = new POSModel(fis);
            this.tagger = new POSTaggerME(modelFile);
        }
        catch (Exception e) {
            this.logger.info((Object)("Error loading POS tagger model: " + this.posModelPath));
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        this.logger.info((Object)"process(JCas)");
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        for (Sentence sentence : sentences) {
            ArrayList<BaseToken> printableTokens = new ArrayList<BaseToken>();
            for (BaseToken token : JCasUtil.selectCovered(BaseToken.class, (AnnotationFS)sentence)) {
                if (token instanceof NewlineToken) continue;
                printableTokens.add(token);
            }
            String[] words = new String[printableTokens.size()];
            for (int i = 0; i < words.length; ++i) {
                words[i] = ((BaseToken)printableTokens.get(i)).getCoveredText();
            }
            if (words.length <= 0) continue;
            String[] wordTagList = this.tagger.tag(words);
            try {
                for (int i = 0; i < printableTokens.size(); ++i) {
                    BaseToken token = (BaseToken)printableTokens.get(i);
                    String posTag = wordTagList[i];
                    token.setPartOfSpeech(posTag);
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new AnalysisEngineProcessException("sentence being tagged is: '" + sentence.getCoveredText() + "'", null, (Throwable)e);
            }
        }
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(POSTagger.class, (TypeSystemDescription)TypeSystemDescriptionFactory.createTypeSystemDescription(), (TypePriorities)TypePrioritiesFactory.createTypePriorities((Class[])new Class[]{Segment.class, Sentence.class, BaseToken.class}), (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String model) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(POSTagger.class, (TypeSystemDescription)TypeSystemDescriptionFactory.createTypeSystemDescription(), (TypePriorities)TypePrioritiesFactory.createTypePriorities((Class[])new Class[]{Segment.class, Sentence.class, BaseToken.class}), (Object[])new Object[]{"PosModelFile", model});
    }
}

