/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.libsvm;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.Classifier_ImplBase;
import org.cleartk.ml.util.featurevector.FeatureVector;

public abstract class LibSvmClassifier<OUTCOME_TYPE, ENCODED_OUTCOME_TYPE>
extends Classifier_ImplBase<FeatureVector, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> {
    protected svm_model model;

    public LibSvmClassifier(FeaturesEncoder<FeatureVector> featuresEncoder, OutcomeEncoder<OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> outcomeEncoder, svm_model model) {
        super(featuresEncoder, outcomeEncoder);
        this.model = model;
    }

    public OUTCOME_TYPE classify(List<Feature> features) throws CleartkProcessingException {
        FeatureVector featureVector = (FeatureVector)this.featuresEncoder.encodeAll(features);
        ENCODED_OUTCOME_TYPE encodedOutcome = this.decodePrediction(svm.svm_predict((svm_model)this.model, (svm_node[])LibSvmClassifier.convertToLIBSVM(featureVector)));
        return (OUTCOME_TYPE)this.outcomeEncoder.decode(encodedOutcome);
    }

    public Map<OUTCOME_TYPE, Double> score(List<Feature> features) throws CleartkProcessingException {
        FeatureVector featureVector = (FeatureVector)this.featuresEncoder.encodeAll(features);
        double[] decisionValues = new double[this.model.nr_class];
        svm.svm_predict_probability((svm_model)this.model, (svm_node[])LibSvmClassifier.convertToLIBSVM(featureVector), (double[])decisionValues);
        HashMap results = Maps.newHashMap();
        for (int i = 0; i < this.model.nr_class; ++i) {
            int intLabel = this.model.label[i];
            Object outcome = this.outcomeEncoder.decode(this.decodePrediction(intLabel));
            results.put(outcome, decisionValues[i]);
        }
        return results;
    }

    protected static svm_node[] convertToLIBSVM(FeatureVector featureVector) {
        ArrayList<svm_node> nodes = new ArrayList<svm_node>();
        for (FeatureVector.Entry entry : featureVector) {
            svm_node node = new svm_node();
            node.index = entry.index;
            node.value = entry.value;
            nodes.add(node);
        }
        return nodes.toArray(new svm_node[nodes.size()]);
    }

    protected abstract ENCODED_OUTCOME_TYPE decodePrediction(double var1);
}

