/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.libsvm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.cleartk.ml.Classifier;
import org.cleartk.ml.jar.ClassifierBuilder_ImplBase;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.util.featurevector.FeatureVector;

public abstract class GenericLibSvmClassifierBuilder<CLASSIFIER_TYPE extends Classifier<OUTCOME_TYPE>, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE, MODEL_TYPE>
extends ClassifierBuilder_ImplBase<CLASSIFIER_TYPE, FeatureVector, OUTCOME_TYPE, ENCODED_OUTCOME_TYPE> {
    public static final String ATTRIBUTES_NAME = "LIBSVM";
    protected MODEL_TYPE model;

    public File getTrainingDataFile(File dir) {
        return new File(dir, this.getTrainingDataName());
    }

    public File getModelFile(File dir) {
        return new File(dir, this.getModelName());
    }

    protected abstract String getTrainingDataName();

    protected abstract String getModelName();

    protected abstract MODEL_TYPE loadModel(InputStream var1) throws IOException;

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)this.getModelName(), (File)this.getModelFile(dir));
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)this.getModelName());
        this.model = this.loadModel(modelStream);
    }
}

