/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.doccat;

import opennlp.uima.doccat.AbstractDocumentCategorizer;
import opennlp.uima.util.AnnotatorUtil;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;

public class DocumentCategorizer
extends AbstractDocumentCategorizer {
    private Type mCategoryType;
    private Feature mCategoryFeature;

    @Override
    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mCategoryType = AnnotatorUtil.getRequiredTypeParameter(this.getContext(), typeSystem, "opennlp.uima.doccat.CategoryType");
        this.mCategoryFeature = AnnotatorUtil.getRequiredFeatureParameter(this.getContext(), this.mCategoryType, "opennlp.uima.doccat.CategoryFeature", "uima.cas.String");
    }

    @Override
    protected void setBestCategory(CAS tcas, String bestCategory) {
        AnnotationFS categoryAnnotation;
        AnnotationIndex categoryIndex = tcas.getAnnotationIndex(this.mCategoryType);
        if (categoryIndex.size() > 0) {
            categoryAnnotation = (AnnotationFS)categoryIndex.iterator().next();
        } else {
            categoryAnnotation = tcas.createAnnotation(this.mCategoryType, 0, tcas.getDocumentText().length());
            tcas.getIndexRepository().addFS((FeatureStructure)categoryAnnotation);
        }
        categoryAnnotation.setStringValue(this.mCategoryFeature, bestCategory);
    }
}

