/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet.factory;

import cc.mallet.classify.C45;
import cc.mallet.classify.C45Trainer;
import cc.mallet.classify.ClassifierTrainer;
import org.cleartk.ml.mallet.factory.ClassifierTrainerFactory;

public class C45TrainerFactory
implements ClassifierTrainerFactory<C45> {
    public static final String NAME = "C45";

    @Override
    public ClassifierTrainer<C45> createTrainer(String ... args) {
        C45Trainer trainer = new C45Trainer();
        if (args != null) {
            if (args.length % 2 != 0) {
                throw new IllegalArgumentException("each argument must be supplied with a value:  " + this.getUsageMessage());
            }
            for (int i = 0; i < args.length; i += 2) {
                String optionName = args[i];
                String optionValue = args[i + 1];
                if (optionName.equals("--depthLimited")) {
                    trainer.setDepthLimited(Boolean.parseBoolean(optionValue));
                    continue;
                }
                if (optionName.equals("--doPruning")) {
                    trainer.setDoPruning(Boolean.parseBoolean(optionValue));
                    continue;
                }
                if (optionName.equals("--maxDepth")) {
                    trainer.setMaxDepth(Integer.parseInt(optionValue));
                    continue;
                }
                if (optionName.equals("--minNumInsts")) {
                    trainer.setMinNumInsts(Integer.parseInt(optionValue));
                    continue;
                }
                throw new IllegalArgumentException(String.format("the argument %1$s is invalid.  ", optionName) + this.getUsageMessage());
            }
        }
        return trainer;
    }

    @Override
    public String getUsageMessage() {
        return "The arguments for C45TrainerFactory.createTrainer(String...args) should be either empty or include any of the following:\n--depthLimited boolean\n--doPruning boolean\n--maxDepth integer\n--minNumInsts integer";
    }
}

