/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.mallet;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.encoder.features.BooleanEncoder;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.features.NameNumberFeaturesEncoder;
import org.cleartk.ml.encoder.features.NumberEncoder;
import org.cleartk.ml.encoder.features.StringEncoder;
import org.cleartk.ml.jar.DataWriter_ImplBase;
import org.cleartk.ml.mallet.MalletClassifierBuilder_ImplBase;
import org.cleartk.ml.mallet.MalletClassifier_ImplBase;

public abstract class MalletDataWriter_ImplBase<CLASSIFIER_BUILDER_TYPE extends MalletClassifierBuilder_ImplBase<? extends MalletClassifier_ImplBase<OUTCOME_TYPE>, OUTCOME_TYPE>, OUTCOME_TYPE>
extends DataWriter_ImplBase<CLASSIFIER_BUILDER_TYPE, List<NameNumber>, OUTCOME_TYPE, String> {
    public MalletDataWriter_ImplBase(File outputDirectory) throws IOException {
        super(outputDirectory);
        NameNumberFeaturesEncoder fe = new NameNumberFeaturesEncoder();
        fe.addEncoder((FeatureEncoder)new NumberEncoder());
        fe.addEncoder((FeatureEncoder)new BooleanEncoder());
        fe.addEncoder((FeatureEncoder)new StringEncoder());
        this.setFeaturesEncoder((FeaturesEncoder)fe);
    }

    public void writeEncoded(List<NameNumber> features, String outcome) throws CleartkProcessingException {
        if (outcome == null) {
            throw CleartkProcessingException.noInstanceOutcome(features);
        }
        if (features.size() == 0) {
            this.trainingDataWriter.print("null:0 ");
        } else {
            for (NameNumber nameNumber : features) {
                this.trainingDataWriter.print(nameNumber.name + ":" + nameNumber.number + " ");
            }
        }
        this.trainingDataWriter.print(outcome);
        this.trainingDataWriter.println();
    }
}

