/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.piper;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.ctakes.core.pipeline.PiperFileReader;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;

public final class PiperTextFilter
extends DocumentFilter {
    private static final Logger LOGGER = Logger.getLogger((String)"PiperTextFilter");
    private final TextValidator _textValidator;
    private final TextFormatter _textFormatter;

    public PiperTextFilter(DefaultStyledDocument document) {
        this._textFormatter = new TextFormatter(document);
        this._textValidator = new TextValidator(document);
        document.setDocumentFilter(this);
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int begin, int length) throws BadLocationException {
        super.remove(fb, begin, length);
        if (PiperTextFilter.shouldReformat(fb.getDocument(), begin, length)) {
            this.formatText(fb.getDocument());
        }
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int begin, String text, AttributeSet attr) throws BadLocationException {
        super.insertString(fb, begin, text, attr);
        if (PiperTextFilter.shouldReformat(fb.getDocument(), begin, text.length())) {
            this.formatText(fb.getDocument());
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int begin, int length, String text, AttributeSet attrs) throws BadLocationException {
        super.replace(fb, begin, length, text, attrs);
        if (PiperTextFilter.shouldReformat(fb.getDocument(), begin, length)) {
            this.formatText(fb.getDocument());
        }
    }

    private static boolean shouldReformat(Document document, int begin, int length) throws BadLocationException {
        int testLength = Math.min(length + 2, document.getLength() - begin);
        String deltaText = document.getText(begin, testLength);
        return deltaText.contains(" ") || deltaText.contains("\n") || deltaText.contains("\t");
    }

    private void formatText(Document document) {
        if (StyledDocument.class.isInstance(document)) {
            SwingUtilities.invokeLater(this._textFormatter);
        }
    }

    private static boolean shouldValidate(Document document, int begin, int length) throws BadLocationException {
        int testLength = Math.min(length + 2, document.getLength() - begin);
        String deltaText = document.getText(begin, testLength);
        return deltaText.contains("\n");
    }

    public boolean validateText() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> validator = executor.submit(this._textValidator);
        try {
            boolean valid = validator.get(1000L, TimeUnit.MILLISECONDS);
            executor.shutdown();
            return valid;
        }
        catch (InterruptedException | ExecutionException | TimeoutException multE) {
            LOGGER.warn((Object)"Piper validation timed out.");
            executor.shutdown();
            return false;
        }
    }

    private static final class TextValidator
    extends TextFormatter
    implements Callable<Boolean> {
        private final PiperFileReader _reader = new PiperFileReader();
        private boolean _haveReader;

        private TextValidator(StyledDocument document) {
            super(document);
        }

        @Override
        public Boolean call() {
            this._haveReader = false;
            boolean valid = true;
            try {
                String text = this._document.getText(0, this._document.getLength());
                int lineBegin = 0;
                boolean lineEnded = false;
                for (int i = 0; i < this._document.getLength(); ++i) {
                    lineEnded = false;
                    if (text.charAt(i) != '\n') continue;
                    if (this.validateLine(lineBegin, i)) {
                        this.formatLine(lineBegin, i);
                    } else {
                        valid = false;
                    }
                    lineBegin = i + 1;
                    lineEnded = true;
                }
                if (!lineEnded) {
                    this.formatLine(lineBegin, this._document.getLength());
                    valid = false;
                }
            }
            catch (BadLocationException blE) {
                LOGGER.error((Object)blE.getMessage());
                valid = false;
            }
            this._document.setCharacterAttributes(this._document.getLength(), 1, (AttributeSet)this._styles.get("PLAIN"), true);
            this._reader.getBuilder().clear();
            if (!this._haveReader) {
                LOGGER.warn((Object)"No Reader specified");
                return false;
            }
            return valid;
        }

        private boolean validateLine(int begin, int end) throws BadLocationException {
            int length = end - begin;
            if (length <= 0) {
                return true;
            }
            String text = this._document.getText(begin, length);
            if (text.startsWith("#") || text.startsWith("//") || text.startsWith("!")) {
                return true;
            }
            if (text.startsWith("readFiles ") || text.startsWith("reader ")) {
                if (this._haveReader) {
                    LOGGER.warn((Object)"More than one Reader specified");
                    this._document.setCharacterAttributes(begin, end, (AttributeSet)this._styles.get("ERROR"), true);
                    return false;
                }
                this._haveReader = true;
            }
            try {
                return this._reader.parsePipelineLine(text);
            }
            catch (UIMAException uE) {
                LOGGER.warn((Object)uE.getMessage());
                this._document.setCharacterAttributes(begin, end, (AttributeSet)this._styles.get("ERROR"), true);
                return false;
            }
        }
    }

    private static class TextFormatter
    implements Runnable {
        final StyledDocument _document;
        final Map<String, Style> _styles = new HashMap<String, Style>();

        private TextFormatter(StyledDocument document) {
            this._document = document;
            this.createStyles();
        }

        @Override
        public void run() {
            try {
                String text = this._document.getText(0, this._document.getLength());
                int lineBegin = 0;
                boolean lineEnded = false;
                for (int i = 0; i < this._document.getLength(); ++i) {
                    lineEnded = false;
                    if (text.charAt(i) != '\n') continue;
                    this.formatLine(lineBegin, i);
                    lineBegin = i + 1;
                    lineEnded = true;
                }
                if (!lineEnded) {
                    this.formatLine(lineBegin, this._document.getLength());
                }
            }
            catch (BadLocationException blE) {
                LOGGER.error((Object)blE.getMessage());
            }
        }

        private void createStyles() {
            this.createStyle("PLAIN", Color.BLACK, false, "PLAIN");
            Style comment = this.createStyle("COMMENT", Color.GRAY, false, "COMMENT");
            StyleConstants.setItalic(comment, true);
            Style error = this.createStyle("ERROR", Color.RED, false, "ERROR");
            StyleConstants.setUnderline(error, true);
            this.createStyle("PIPE_BIT", Color.BLUE, false, "PIPE_BIT");
            this.createStyle("BOLD_PIPE_BIT", Color.BLUE, "BOLD_PIPE_BIT");
            this.createStyle("PARAMETER", Color.YELLOW, "PARAMETER");
            this.createStyle("LOAD", Color.MAGENTA, "load");
            this.createStyle("PACKAGE", Color.YELLOW.darker(), "package");
            this.createStyle("SET", Color.ORANGE.darker(), "set", "cli");
            this.createStyle("READER", Color.GREEN.darker().darker(), "reader", "readFiles");
            this.createStyle("ADD", Color.CYAN.darker().darker(), "add", "addLogged", "addDescription", "addLast");
            this.createStyle("WRITE_XMI", Color.BLUE.darker(), "writeXmis", "collectCuis", "collectEntities");
        }

        private Style createStyle(String name, Color color, String ... keys) {
            return this.createStyle(name, color, true, keys);
        }

        private Style createStyle(String name, Color color, boolean bold, String ... keys) {
            Style style = this._document.addStyle(name, null);
            StyleConstants.setForeground(style, color);
            if (bold) {
                StyleConstants.setBold(style, true);
            }
            Arrays.stream(keys).forEach(k -> this._styles.put((String)k, style));
            return style;
        }

        boolean formatLine(int begin, int end) throws BadLocationException {
            int length = end - begin;
            if (length <= 0) {
                return true;
            }
            String text = this._document.getText(begin, length);
            if (text.startsWith("#") || text.startsWith("//") || text.startsWith("!")) {
                this._document.setCharacterAttributes(begin, length, this._styles.get("COMMENT"), true);
                return true;
            }
            int commandEnd = text.indexOf(32);
            if (commandEnd < 0) {
                commandEnd = length;
            }
            String command = text.substring(0, commandEnd);
            Style commandStyle = this.getCommandStyle(command);
            this._document.setCharacterAttributes(begin, commandEnd, commandStyle, true);
            if (length > commandEnd) {
                int styleEnd = commandEnd + 1;
                if (command.equals("reader") || command.startsWith("add")) {
                    int bitStart = commandEnd + 1;
                    int bitEnd = text.indexOf(32, bitStart);
                    if (bitEnd < 0) {
                        bitEnd = length;
                    }
                    int bitBold = bitStart;
                    String pipeBitText = text.substring(bitStart, bitEnd);
                    int dotIndex = pipeBitText.lastIndexOf(46);
                    if (dotIndex > 0) {
                        bitBold = bitStart + dotIndex + 1;
                        this._document.setCharacterAttributes(begin + bitStart, bitBold - bitStart, this._styles.get("PIPE_BIT"), true);
                    }
                    this._document.setCharacterAttributes(begin + bitBold, bitEnd - bitBold, this._styles.get("BOLD_PIPE_BIT"), true);
                    styleEnd = bitEnd;
                }
                this._document.setCharacterAttributes(begin + styleEnd, length - styleEnd, this._styles.get("PLAIN"), true);
            }
            return !commandStyle.equals(this._styles.get("ERROR"));
        }

        private Style getCommandStyle(String command) {
            Style style = this._styles.get(command);
            if (style == null) {
                return this._styles.get("ERROR");
            }
            return style;
        }
    }
}

