/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.info;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.component.CellRendererLabel;
import org.apache.ctakes.gui.pipeline.bit.info.ProductIconFactory;
import org.apache.ctakes.gui.util.ColorFactory;
import org.apache.log4j.Logger;

public final class TypeProductRenderer
implements ListCellRenderer<Object> {
    private static final Logger LOGGER = Logger.getLogger((String)"TypeProductRenderer");
    private final JLabel _delegate = new CellRendererLabel();

    public TypeProductRenderer() {
        this._delegate.setBackground(UIManager.getColor("List.background"));
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!PipeBitInfo.TypeProduct.class.isInstance(value)) {
            LOGGER.error((Object)(value.getClass().getName() + " is not a TypeProduct"));
            this._delegate.setIcon(null);
            this._delegate.setText("Invalid");
            this._delegate.setToolTipText("Invalid Information");
            return this._delegate;
        }
        PipeBitInfo.TypeProduct typeProduct = (PipeBitInfo.TypeProduct)value;
        Icon icon = ProductIconFactory.getInstance().getIcon(typeProduct);
        this._delegate.setIcon(icon);
        String name = typeProduct.name();
        Color color = ColorFactory.getColor(name);
        this._delegate.setForeground(color);
        String prettyName = name.charAt(0) + name.substring(1, name.length());
        this._delegate.setText(prettyName);
        return this._delegate;
    }
}

