/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.ctakes.gui.component.DisablerPane;
import org.apache.ctakes.gui.pipeline.MainPanel2;
import org.apache.ctakes.gui.pipeline.bit.PipeBitPainter;
import org.apache.ctakes.gui.util.IconLoader;
import org.apache.log4j.Logger;

public final class PiperCreator {
    private static final Logger LOGGER = Logger.getLogger((String)"PiperCreator");

    private PiperCreator() {
    }

    private static JFrame createFrame() {
        JFrame frame = new JFrame("cTAKES Simple Pipeline Fabricator");
        frame.setDefaultCloseOperation(3);
        Dimension size = new Dimension(800, 600);
        frame.setSize(size);
        frame.setMinimumSize(size);
        return frame;
    }

    private static MainPanel2 createMainPanel() {
        return new MainPanel2();
    }

    public static void main(String ... args) {
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                UIManager.getDefaults().put("SplitPane.border", BorderFactory.createEmptyBorder());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException multE) {
                LOGGER.error((Object)multE.getLocalizedMessage());
            }
            JFrame frame = PiperCreator.createFrame();
            MainPanel2 mainPanel = PiperCreator.createMainPanel();
            frame.add(mainPanel);
            frame.pack();
            frame.setVisible(true);
            DisablerPane.getInstance().initialize(frame);
            PipeBitPainter.getInstance().loadIcons();
            LOGGER.info((Object)"1. Select any Pipe Bit in the list on the left.");
            LOGGER.info((Object)"   A Pipe Bit is any part of a full Pipeline: Reader, Annotator, Writer.");
            LOGGER.info((Object)"   Once selected, the center panel will be populated with information on the Pipe Bit.");
            LOGGER.info((Object)"2. Edit values for Pipe Bit Parameters.");
            LOGGER.info((Object)"   Parameters and values are displayed in the central table.");
            LOGGER.info((Object)"   Values can be edited directly on the table.");
            LOGGER.info((Object)"   In the rightmost column is a button to open a Filechooser if needed.");
            LOGGER.info((Object)"3. Add the Pipe Bit to the Pipeline.  Added Pipe Bits will appear in the text panel.");
            LOGGER.info((Object)"   When all Pipe Bit requirements are met, the Add Pipe Bit (\"+\") button will be enabled.");
            LOGGER.info((Object)"4. Validate the Pipeline by clicking the runner at the starting line.");
            LOGGER.info((Object)"   Any part of the pipeline that is invalid will be underlined and red.");
            LOGGER.info((Object)"5. Run the Pipeline.  When the Pipeline is valid the Runner button will be enabled.");
            LOGGER.info((Object)"-  You can manually edit the pipeline at any time.");
            Object[] options = new Object[]{"Scan"};
            Icon scanIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/FindOnPc_48.png");
            JOptionPane.showOptionDialog(frame, "A Scan must be performed to find available Pipe Bits.\nPipe Bits are used to assemble a cTAKES Pipeline.", "Find Pipe Bits", 0, -1, scanIcon, options, options[0]);
            mainPanel.findPipeBits();
        });
    }
}

