/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ctakes.gui.dictionary.umls.Concept;

public final class RareWordUtil {
    private static final Set<String> BAD_POS_TERM_SET;
    private static final Pattern SPACE_PATTERN;
    public static final IndexedRareWord NULL_RARE_WORD;

    private RareWordUtil() {
    }

    public static Collection<String> getUnwantedPosTexts() {
        return Collections.unmodifiableCollection(BAD_POS_TERM_SET);
    }

    public static boolean isRarableToken(String token) {
        if (token.length() <= 1) {
            return false;
        }
        boolean hasLetter = false;
        for (int i = 0; i < token.length(); ++i) {
            if (!Character.isLetter(token.charAt(i))) continue;
            hasLetter = true;
            break;
        }
        return hasLetter && !BAD_POS_TERM_SET.contains(token);
    }

    public static Map<String, Long> getTokenCounts(Collection<Concept> concepts) {
        return concepts.stream().map(Concept::getTexts).flatMap(Collection::stream).map(SPACE_PATTERN::split).flatMap(Arrays::stream).filter(RareWordUtil::isRarableToken).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
    }

    private static void incrementCount(Map<String, Integer> tokenCounts, String token) {
        Integer count = tokenCounts.get(token);
        if (count == null) {
            count = 0;
        }
        tokenCounts.put(token, count + 1);
    }

    public static IndexedRareWord getIndexedRareWord(String text, Map<String, Long> tokenCounts) {
        String[] tokens = SPACE_PATTERN.split(text);
        int bestIndex = 0;
        long bestCount = Long.MAX_VALUE;
        for (int i = 0; i < tokens.length; ++i) {
            Long count;
            if (tokens[i].length() >= 48 || (count = tokenCounts.get(tokens[i])) == null || count >= bestCount) continue;
            bestIndex = i;
            bestCount = count;
        }
        if (bestCount == Long.MAX_VALUE) {
            return NULL_RARE_WORD;
        }
        return new IndexedRareWord(tokens[bestIndex], bestIndex, tokens.length);
    }

    static {
        String[] BAD_POS_TERMS = new String[]{"be", "has", "have", "had", "do", "does", "did", "is", "isn", "am", "are", "was", "were", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "and", "or", "but", "for", "nor", "so", "yet", "while", "because", "this", "that", "these", "those", "the", "an", "a", "there", "can", "should", "will", "may", "shall", "might", "must", "could", "would", "some", "many", "any", "each", "all", "few", "most", "both", "half", "none", "twice", "at", "before", "after", "behind", "beneath", "beside", "between", "into", "through", "across", "of", "concerning", "like", "unlike", "except", "with", "within", "without", "toward", "to", "past", "against", "during", "until", "throughout", "below", "besides", "beyond", "from", "inside", "near", "outside", "since", "upon", "my", "our", "your", "her", "their", "whose", "i", "you", "he", "she", "it", "them", "they", "we", "us", "mine", "yours", "his", "hers", "its", "ours", "theirs", "about", "off", "up", "along", "away", "back", "by", "down", "forward", "in", "on", "out", "over", "around", "under", "to", "what", "whatever", "which", "whichever", "who", "whom", "which", "that", "whoever", "whomever", "how", "where", "when", "however", "wherever", "whenever", "no", "not", "oh", "mr", "mrs", "miss", "dr", "as", "only", "also", "either", "neither", "whether", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety", "hundred", "thousand", "million", "billion", "trillion"};
        BAD_POS_TERM_SET = new HashSet<String>(Arrays.asList(BAD_POS_TERMS));
        SPACE_PATTERN = Pattern.compile("\\s+");
        NULL_RARE_WORD = new IndexedRareWord(null, -1, -1);
    }

    public static final class IndexedRareWord {
        public final String __word;
        public final int __index;
        public final int __tokenCount;

        private IndexedRareWord(String word, int index, int tokenCount) {
            this.__word = word;
            this.__index = index;
            this.__tokenCount = tokenCount;
        }
    }
}

