/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileSystemView;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.gui.dictionary.util.TokenUtil;
import org.apache.log4j.Logger;

public final class FileUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"FileUtil");

    private FileUtil() {
    }

    public static String parseDirText(String dirPath) {
        if (dirPath == null || dirPath.isEmpty()) {
            return FileUtil.parseDirText(".");
        }
        if (dirPath.startsWith("~")) {
            return FileUtil.parseDirText(dirPath.replaceAll("~", System.getProperty("user.home")));
        }
        if (dirPath.equals(".")) {
            String userDir = System.getProperty("user.dir");
            if (userDir == null || userDir.isEmpty()) {
                return FileSystemView.getFileSystemView().getDefaultDirectory().getPath();
            }
            return userDir;
        }
        if (dirPath.startsWith("..")) {
            String userDirPath = FileUtil.parseDirText(".");
            File cwd = new File(userDirPath);
            String cwdPath = dirPath;
            while (cwdPath.startsWith("..")) {
                if (!cwd.isDirectory()) {
                    LOGGER.error((Object)("Invalid directory " + dirPath));
                    System.exit(1);
                }
                cwd = cwd.getParentFile();
                if (cwdPath.equals("..")) {
                    return cwd.getPath();
                }
                cwdPath = cwdPath.substring(3);
            }
            return cwd.getPath();
        }
        return dirPath;
    }

    public static BufferedReader createReader(String filePath) {
        try {
            File file = FileLocator.locateFile((String)filePath);
            if (!file.canRead()) {
                LOGGER.error((Object)("Cannot read file " + filePath));
                System.exit(1);
            }
            return new BufferedReader(new FileReader(file));
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Cannot create Reader for " + filePath));
            LOGGER.error((Object)ioE.getMessage());
            System.exit(1);
            return null;
        }
    }

    private static BufferedWriter createWriter(String filePath) {
        try {
            File file = FileLocator.locateFile((String)filePath);
            if (file.getParentFile() != null && !file.getParentFile().isDirectory()) {
                file.getParentFile().mkdirs();
            }
            return new BufferedWriter(new FileWriter(file, true));
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Cannot create Writer for " + filePath));
            LOGGER.error((Object)ioE.getMessage());
            System.exit(1);
            return null;
        }
    }

    private static String readLine(BufferedReader reader, String filePath) {
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!line.trim().isEmpty() && !line.trim().startsWith("//")) {
                    return line;
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Error reading from file " + filePath));
        }
        return null;
    }

    public static List<String> readBsvTokens(BufferedReader reader, String filePath) {
        String line = FileUtil.readLine(reader, filePath);
        if (line == null) {
            return null;
        }
        return TokenUtil.getBsvItems(line);
    }

    public static List<String> readCsvTokens(BufferedReader reader, String filePath) {
        String line = FileUtil.readLine(reader, filePath);
        if (line == null) {
            return null;
        }
        return TokenUtil.getCsvItems(line);
    }

    public static List<String> readTildeTokens(BufferedReader reader, String filePath) {
        String line = FileUtil.readLine(reader, filePath);
        if (line == null) {
            return null;
        }
        return TokenUtil.getTildeItems(line);
    }

    public static void writeOneColumn(String filePath, String description, Collection<String> list) {
        LOGGER.info((Object)("Writing " + description + " to " + filePath));
        long lineCount = 0L;
        try (BufferedWriter writer = FileUtil.createWriter(filePath);){
            for (String item : list) {
                writer.write(item);
                writer.newLine();
                if (++lineCount % 100000L != 0L) continue;
                LOGGER.info((Object)("File Line " + lineCount));
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Error writing " + description + " on line " + lineCount + " in file " + filePath));
        }
        LOGGER.info((Object)("Wrote " + lineCount + " " + description + " to " + filePath));
    }

    public static Collection<String> readOneColumn(String listFilePath, String description) {
        LOGGER.info((Object)("Reading " + description + " from " + listFilePath));
        HashSet<String> listItems = new HashSet<String>();
        long lineCount = 0L;
        try (BufferedReader reader = FileUtil.createReader(listFilePath);){
            String line = FileUtil.readLine(reader, listFilePath);
            while (line != null) {
                listItems.add(line);
                if (++lineCount % 100000L == 0L) {
                    LOGGER.info((Object)("File Line " + lineCount));
                }
                line = FileUtil.readLine(reader, listFilePath);
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
        }
        LOGGER.info((Object)("File Lines " + lineCount + "\t " + description + " " + listItems.size()));
        return listItems;
    }

    public static void writeNamedSets(String filePath, String description, Map<String, Collection<String>> namedSets) {
        LOGGER.info((Object)("Writing " + description + " to " + filePath));
        long lineCount = 0L;
        try (BufferedWriter writer = FileUtil.createWriter(filePath);){
            for (Map.Entry<String, Collection<String>> namedSet : namedSets.entrySet()) {
                writer.write(TokenUtil.createBsvLine(namedSet.getKey(), TokenUtil.createCsvLine(namedSet.getValue())));
                writer.newLine();
                if (++lineCount % 100000L != 0L) continue;
                LOGGER.info((Object)("File Line " + lineCount));
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Error writing " + description + " on line " + lineCount + " in file " + filePath));
        }
        LOGGER.info((Object)("Wrote " + lineCount + " " + description + " to " + filePath));
    }

    @Deprecated
    public static Map<String, Collection<String>> readNamedSetsOld(String filePath, String description) {
        Collection<String> lines = FileUtil.readOneColumn(filePath, description);
        HashMap<String, Collection<String>> namedSets = new HashMap<String, Collection<String>>(lines.size());
        for (String line : lines) {
            List<String> nameAndList = TokenUtil.getBsvItems(line);
            if (nameAndList == null || nameAndList.size() != 2) {
                LOGGER.error((Object)("Bad line " + line));
                continue;
            }
            namedSets.put(nameAndList.get(0), TokenUtil.getCsvItems(nameAndList.get(1)));
        }
        return namedSets;
    }
}

