/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.umls;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ctakes.gui.dictionary.umls.Concept;
import org.apache.ctakes.gui.dictionary.umls.CuiCodeUtil;
import org.apache.ctakes.gui.dictionary.umls.MrstyIndex;
import org.apache.ctakes.gui.dictionary.umls.Tui;
import org.apache.ctakes.gui.dictionary.util.FileUtil;
import org.apache.log4j.Logger;

public final class MrstyParser {
    private static final Logger LOGGER = Logger.getLogger((String)"MrStyParser");
    private static final String MRSTY_SUB_PATH = "/META/MRSTY.RRF";

    private MrstyParser() {
    }

    public static Map<Long, Concept> createConceptsForTuis(String umlsPath, Collection<Tui> wantedTuis) {
        String mrstyPath = umlsPath + MRSTY_SUB_PATH;
        LOGGER.info((Object)("Compiling list of Cuis with wanted Tuis using " + mrstyPath));
        long lineCount = 0L;
        HashMap<Long, Concept> wantedConcepts = new HashMap<Long, Concept>();
        EnumSet<Tui> usedTuis = EnumSet.noneOf(Tui.class);
        EnumMap<Tui, Long> tuiCodeCount = new EnumMap<Tui, Long>(Tui.class);
        for (Tui tui : wantedTuis) {
            tuiCodeCount.put(tui, 0L);
        }
        try {
            BufferedReader reader = FileUtil.createReader(mrstyPath);
            Object object = null;
            try {
                List<String> tokens = FileUtil.readBsvTokens(reader, mrstyPath);
                while (tokens != null) {
                    ++lineCount;
                    if (tokens.size() > MrstyIndex.TUI._index) {
                        Tui tuiEnum = Tui.valueOf(tokens.get(MrstyIndex.TUI._index));
                        if (!wantedTuis.contains((Object)tuiEnum)) {
                            tokens = FileUtil.readBsvTokens(reader, mrstyPath);
                            continue;
                        }
                        Long cuiCode = CuiCodeUtil.getInstance().getCuiCode(tokens.get(MrstyIndex.CUI._index));
                        Concept concept = (Concept)wantedConcepts.get(cuiCode);
                        if (concept == null) {
                            concept = new Concept();
                            wantedConcepts.put(cuiCode, concept);
                        }
                        concept.addTui(tuiEnum);
                        usedTuis.add(tuiEnum);
                        long count = (Long)tuiCodeCount.get((Object)tuiEnum);
                        tuiCodeCount.put(tuiEnum, count + 1L);
                    }
                    if (lineCount % 100000L == 0L) {
                        String counts = tuiCodeCount.entrySet().stream().map(e -> ((Tui)((Object)((Object)e.getKey()))).name() + " " + e.getValue()).collect(Collectors.joining(", "));
                        LOGGER.info((Object)("File Line " + lineCount + "\t Cuis: " + counts));
                    }
                    tokens = FileUtil.readBsvTokens(reader, mrstyPath);
                }
            }
            catch (Throwable tokens) {
                object = tokens;
                throw tokens;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable tokens) {
                            ((Throwable)object).addSuppressed(tokens);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
        }
        String counts = tuiCodeCount.entrySet().stream().map(e -> ((Tui)((Object)((Object)e.getKey()))).name() + " " + e.getValue()).collect(Collectors.joining(", "));
        LOGGER.info((Object)("File Lines " + lineCount + "\t Cuis: " + counts));
        if (usedTuis.size() != wantedTuis.size()) {
            wantedTuis.removeAll(usedTuis);
            for (Tui missingTui : wantedTuis) {
                LOGGER.warn((Object)("Could not find Cuis for Tui " + (Object)((Object)missingTui) + " " + missingTui.getDescription()));
            }
        }
        return wantedConcepts;
    }
}

