/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.umls;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class DoseUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"DoseUtil");
    private static final String[] UNIT_ARRAY = new String[]{"gr", "gm", "gram", "grams", "g", "mg", "milligram", "milligrams", "kg", "microgram", "micrograms", "mcg", "ug", "millicurie", "mic", "oz", "lf", "ml", "liter", "milliliter", "l", "milliequivalent", "meq", "usp", "titradose", "unit", "units", "unt", "iu", "u", "mmu", "mm", "cm", "cc", "gauge", "intl", "au", "bau", "mci", "ud", "ww", "vv", "wv", "%", "percent", "%ww", "%vv", "%wv", "actuation", "actuat", "vial", "vil", "packet", "pkt"};
    private static final Collection<String> UNITS = Arrays.asList(UNIT_ARRAY);
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");

    private DoseUtil() {
    }

    public static boolean hasUnit(String text) {
        String[] splits = SPACE_PATTERN.split(text);
        if (splits.length <= 1) {
            return UNITS.contains("text");
        }
        for (int i = 0; i < splits.length - 1; ++i) {
            String split = splits[i];
            if (!Character.isDigit(split.charAt(0))) continue;
            for (int j = 1; j < split.length(); ++j) {
                if (Character.isDigit(split.charAt(j)) || !UNITS.contains(split.substring(j))) continue;
                return true;
            }
            if (!UNITS.contains(splits[++i])) continue;
            return true;
        }
        return false;
    }
}

