/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.dictionary.umls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.util.collection.HashSetMap;
import org.apache.ctakes.gui.dictionary.umls.Tui;
import org.apache.ctakes.gui.dictionary.umls.VocabularyStore;
import org.apache.ctakes.gui.dictionary.util.TextTokenizer;

public final class Concept {
    public static final String PREFERRED_TERM_UNKNOWN = "Unknown Preferred Term";
    private String _preferredText = null;
    private boolean _hasDose = false;
    private final Map<String, Integer> _textCounts = new HashMap<String, Integer>(1);
    private final HashSetMap<String, String> _codes = new HashSetMap(0);
    private final Collection<Tui> _tuis = EnumSet.noneOf(Tui.class);

    public int addTexts(Collection<String> texts) {
        int oldSize = this._textCounts.size();
        texts.forEach(t -> this._textCounts.merge((String)t, 1, (i1, i2) -> i1 + i2));
        return this._textCounts.size() - oldSize;
    }

    public int getCount(String text) {
        return this._textCounts.getOrDefault(text, 0);
    }

    public int getSynonymCount() {
        return this._textCounts.size();
    }

    public void removeTexts(Collection<String> texts) {
        this._textCounts.keySet().removeAll(texts);
    }

    public void removeText(String text) {
        this._textCounts.keySet().remove(text);
    }

    public Collection<String> getTexts() {
        return this._textCounts.keySet();
    }

    public void cullExtensions() {
        boolean nonAlpha;
        String tokenizedPrefText;
        if (!(this._preferredText == null || this._preferredText.isEmpty() || this._preferredText.equals(PREFERRED_TERM_UNKNOWN) || this._textCounts.containsKey(tokenizedPrefText = TextTokenizer.getTokenizedText(this._preferredText.toLowerCase())) || tokenizedPrefText.length() >= 255 || (nonAlpha = tokenizedPrefText.chars().filter(c -> !Character.isAlphabetic(c)).findFirst().isPresent()))) {
            this._textCounts.put(tokenizedPrefText, 1);
        }
        if (this._textCounts.size() < 2) {
            return;
        }
        ArrayList<String> textList = new ArrayList<String>(this._textCounts.keySet());
        HashSet<String> extensionTexts = new HashSet<String>();
        for (int i = 0; i < textList.size() - 1; ++i) {
            String iText = (String)textList.get(i);
            for (int j = i + 1; j < textList.size(); ++j) {
                String jText = (String)textList.get(j);
                if (Concept.textContained(jText, iText)) {
                    extensionTexts.add(jText);
                    continue;
                }
                if (!Concept.textContained(iText, jText)) continue;
                extensionTexts.add(iText);
            }
        }
        this.removeTexts(extensionTexts);
    }

    private static boolean textContained(String containerText, String containedText) {
        int index = containerText.indexOf(containedText);
        return !(index < 0 || index != 0 && containerText.charAt(index - 1) != ' ' || index + containedText.length() != containerText.length() && containerText.charAt(index + containedText.length()) != ' ');
    }

    public void setPreferredText(String text) {
        this._preferredText = text;
    }

    public String getPreferredText() {
        if (this._preferredText != null) {
            return this._preferredText;
        }
        return PREFERRED_TERM_UNKNOWN;
    }

    public void addCode(String source, String code) {
        if (this._codes.placeValue((Object)source, (Object)code)) {
            VocabularyStore.getInstance().addVocabulary(source, code);
        }
    }

    public Collection<String> getVocabularies() {
        return this._codes.keySet();
    }

    public Collection<String> getCodes(String source) {
        Set codes = this._codes.getCollection((Object)source);
        if (codes == null) {
            return Collections.emptyList();
        }
        return codes;
    }

    public void addTui(Tui tui) {
        this._tuis.add(tui);
    }

    public Collection<Tui> getTuis() {
        return this._tuis;
    }

    public boolean hasTui(Collection<Tui> tuis) {
        return this._tuis.stream().anyMatch(tuis::contains);
    }

    public boolean isEmpty() {
        return this._textCounts.isEmpty();
    }
}

