/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class DisablerPane
extends JPanel
implements MouseListener,
MouseMotionListener,
FocusListener {
    private static final Logger LOGGER = Logger.getLogger((String)"DisablerPane");
    private JMenuBar _menuBar;
    private Container _contentPane;
    private boolean _dragging = false;
    private boolean _needToRedispatch = false;

    public static DisablerPane getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private DisablerPane() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
        this.setOpaque(false);
        this.setVisible(false);
    }

    public void initialize(JFrame frame) {
        this._menuBar = frame.getJMenuBar();
        this._contentPane = frame.getContentPane();
        frame.setGlassPane(this);
    }

    public void setNeedToRedispatch(boolean need) {
        this._needToRedispatch = need;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        g.setColor(new Color(127, 127, 127, 83));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.requestFocus();
        }
        super.setVisible(visible);
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.isVisible()) {
            this.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this._needToRedispatch) {
            this.forwardMouseEvent(event);
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this._needToRedispatch) {
            this.forwardMouseEvent(event);
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this._needToRedispatch) {
            this.forwardMouseEvent(event);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (this._needToRedispatch) {
            this.forwardMouseEvent(event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (this._needToRedispatch) {
            this.forwardMouseEvent(event);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this._needToRedispatch) {
            this.forwardMouseEvent(event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this._needToRedispatch) {
            this.forwardMouseEvent(event);
            this._dragging = false;
        }
    }

    private void forwardMouseEvent(MouseEvent event) {
        Component component;
        if (this._contentPane == null || this._menuBar == null) {
            LOGGER.error((Object)"DisablerPane has not been initialized with a Frame");
            return;
        }
        boolean inMenuBar = false;
        Point point = event.getPoint();
        Container container = this._contentPane;
        Point containerPoint = SwingUtilities.convertPoint(this, point, this._contentPane);
        int eventID = event.getID();
        if (containerPoint.y < 0) {
            inMenuBar = true;
            container = this._menuBar;
            containerPoint = SwingUtilities.convertPoint(this, point, this._menuBar);
            this.isDragging(eventID);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y)) == null) {
            return;
        }
        this.isDragging(eventID);
        if (inMenuBar || this._dragging) {
            Point componentPoint = SwingUtilities.convertPoint(this, point, component);
            component.dispatchEvent(new MouseEvent(component, eventID, event.getWhen(), event.getModifiers(), componentPoint.x, componentPoint.y, event.getClickCount(), event.isPopupTrigger()));
        }
    }

    private void isDragging(int eventID) {
        if (eventID == 501) {
            this._dragging = true;
        }
    }

    private static final class InstanceHolder {
        private static final DisablerPane INSTANCE = new DisablerPane();

        private InstanceHolder() {
        }
    }
}

