/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.feature.FilteringExtractor;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.timeml.tlink.TemporalLinkAnnotator_ImplBase;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.token.type.Sentence;

public class TemporalLinkEventToDocumentCreationTimeAnnotator
extends TemporalLinkAnnotator_ImplBase<Event, DocumentCreationTime> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TemporalLinkEventToDocumentCreationTimeAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LibLinearStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(TemporalLinkEventToDocumentCreationTimeAnnotator.class, (Object[])new Object[0]);
        }
    };

    public TemporalLinkEventToDocumentCreationTimeAnnotator() {
        super(Event.class, DocumentCreationTime.class, "BEFORE", "AFTER", "INCLUDES");
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        ArrayList srcExtractors = Lists.newArrayList();
        srcExtractors.add(new TypePathExtractor(Event.class, "tense"));
        srcExtractors.add(new TypePathExtractor(Event.class, "aspect"));
        srcExtractors.add(new TypePathExtractor(Event.class, "eventClass"));
        srcExtractors.add(new TypePathExtractor(Event.class, "polarity"));
        srcExtractors.add(new TypePathExtractor(Event.class, "modality"));
        srcExtractors.add(new FilteringExtractor<Event>(Event.class, (FeatureExtractor1)new CoveredTextExtractor()){

            protected boolean accept(Event event) {
                return event.getEventClass().equals("ASPECTUAL");
            }
        });
        this.setSourceExtractors(srcExtractors);
    }

    @Override
    protected List<TemporalLinkAnnotator_ImplBase.SourceTargetPair> getSourceTargetPairs(JCas jCas) {
        ArrayList pairs = Lists.newArrayList();
        DocumentCreationTime dct = (DocumentCreationTime)JCasUtil.selectSingle((JCas)jCas, DocumentCreationTime.class);
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Event event : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
                pairs.add(new TemporalLinkAnnotator_ImplBase.SourceTargetPair((TemporalLinkAnnotator_ImplBase)this, (Anchor)event, (Anchor)dct));
            }
        }
        return pairs;
    }
}

