/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.timeml.type.Event;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public abstract class EventAttributeAnnotator<OUTCOME_TYPE>
extends CleartkAnnotator<OUTCOME_TYPE> {
    protected List<FeatureExtractor1<Event>> eventFeatureExtractors;
    protected List<CleartkExtractor<Event, Token>> contextExtractors;

    protected abstract OUTCOME_TYPE getDefaultValue();

    protected abstract OUTCOME_TYPE getAttribute(Event var1);

    protected abstract void setAttribute(Event var1, OUTCOME_TYPE var2);

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.eventFeatureExtractors = Lists.newArrayList();
        this.contextExtractors = Lists.newArrayList();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Event event : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
                ArrayList features = new ArrayList();
                for (FeatureExtractor1<Event> featureExtractor1 : this.eventFeatureExtractors) {
                    features.addAll(featureExtractor1.extract(jCas, (Annotation)event));
                }
                for (CleartkExtractor cleartkExtractor : this.contextExtractors) {
                    features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)event, (Annotation)sentence));
                }
                if (this.isTraining()) {
                    OUTCOME_TYPE attribute = this.getAttribute(event);
                    if (attribute == null) {
                        attribute = this.getDefaultValue();
                    }
                    Instance instance = new Instance();
                    instance.addAll(features);
                    instance.setOutcome(attribute);
                    this.dataWriter.write(instance);
                    continue;
                }
                Object label = this.classifier.classify(features);
                this.setAttribute(event, label);
            }
        }
    }
}

