/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.util;

public class Base64 {
    private static final byte[] BASE64_ALPHABET_ARRAY = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] BASE64_FOR_URL_ALPHABET_ARRAY = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte PAD = 61;

    public static byte[] encode(byte[] bytes) {
        return Base64.encode(bytes, BASE64_ALPHABET_ARRAY, true);
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        return new String(Base64.encode(string.getBytes()));
    }

    public static byte[] encodeForURL(byte[] bytes) {
        return Base64.encode(bytes, BASE64_FOR_URL_ALPHABET_ARRAY, false);
    }

    private static byte[] encode(byte[] bytes, byte[] alphabetArray, boolean usePadding) {
        int _group;
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return bytes;
        }
        int _length = bytes.length;
        int _remainder = _length % 3;
        byte[] _bytes = usePadding ? new byte[(_length + 2) / 3 * 4] : new byte[(_length + 2) / 3 * 4 - (_remainder != 0 ? 3 - _remainder : 0)];
        _length -= _remainder;
        int _index = 0;
        int _i = 0;
        while (_i < _length) {
            _group = (bytes[_i++] & 0xFF) << 16 | (bytes[_i++] & 0xFF) << 8 | bytes[_i++] & 0xFF;
            _bytes[_index++] = alphabetArray[_group >>> 18];
            _bytes[_index++] = alphabetArray[_group >>> 12 & 0x3F];
            _bytes[_index++] = alphabetArray[_group >>> 6 & 0x3F];
            _bytes[_index++] = alphabetArray[_group & 0x3F];
        }
        switch (_remainder) {
            case 0: {
                break;
            }
            case 1: {
                _group = (bytes[_i] & 0xFF) << 4;
                _bytes[_index++] = alphabetArray[_group >>> 6];
                if (usePadding) {
                    _bytes[_index++] = alphabetArray[_group & 0x3F];
                    _bytes[_index++] = 61;
                    _bytes[_index] = 61;
                    break;
                }
                _bytes[_index] = alphabetArray[_group & 0x3F];
                break;
            }
            case 2: {
                _group = ((bytes[_i++] & 0xFF) << 8 | bytes[_i] & 0xFF) << 2;
                _bytes[_index++] = alphabetArray[_group >>> 12];
                _bytes[_index++] = alphabetArray[_group >>> 6 & 0x3F];
                if (usePadding) {
                    _bytes[_index++] = alphabetArray[_group & 0x3F];
                    _bytes[_index] = 61;
                    break;
                }
                _bytes[_index] = alphabetArray[_group & 0x3F];
                break;
            }
        }
        return _bytes;
    }
}

