/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaSubmitParametersPropagation
extends ConfigurableNavigationHandler {
    private static final Logger log = Logger.getLogger(DeltaSubmitParametersPropagation.class.getName());
    private final ConfigurableNavigationHandler handler;

    public DeltaSubmitParametersPropagation(NavigationHandler handler) {
        this.handler = handler instanceof ConfigurableNavigationHandler ? (ConfigurableNavigationHandler)handler : new NoopConfigurableNavigationHandler(handler);
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        return this.handler.getNavigationCase(context, fromAction, outcome);
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.handler.getNavigationCases();
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        NavigationCase navigationCase = this.getNavigationCase(context, fromAction, outcome);
        if (navigationCase == null || navigationCase.isRedirect()) {
            this.handler.handleNavigation(context, fromAction, outcome);
        } else {
            UIViewRoot viewRoot = context.getViewRoot();
            Collection<UIForm> forms = this.findUIForms(viewRoot);
            Map viewAttributes = viewRoot.getViewMap();
            HashMap idToPreviousParametersMapping = (HashMap)viewAttributes.get("previous-parameters");
            if (idToPreviousParametersMapping == null) {
                idToPreviousParametersMapping = new HashMap();
                viewAttributes.put("previous-parameters", idToPreviousParametersMapping);
            }
            for (UIForm form : forms) {
                Map previousParameters = (Map)form.getAttributes().get("previous-parameters");
                if (previousParameters == null) continue;
                idToPreviousParametersMapping.put(form.getId(), new HashMap(previousParameters));
            }
            this.handler.handleNavigation(context, fromAction, outcome);
            context.getViewRoot().getViewMap().put("previous-parameters", idToPreviousParametersMapping);
        }
    }

    private Collection<UIForm> findUIForms(UIViewRoot viewRoot) {
        LinkedList<UIViewRoot> queue = new LinkedList<UIViewRoot>();
        ArrayList<UIForm> result = new ArrayList<UIForm>();
        queue.add(viewRoot);
        while (!queue.isEmpty()) {
            UIComponent cursor = (UIComponent)queue.removeFirst();
            if (cursor instanceof UIForm) {
                result.add((UIForm)cursor);
                continue;
            }
            queue.addAll(cursor.getChildren());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoopConfigurableNavigationHandler
    extends ConfigurableNavigationHandler {
        private final NavigationHandler handler;

        public NoopConfigurableNavigationHandler(NavigationHandler handler) {
            this.handler = handler;
        }

        public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
            log.warning(this.handler + " is not a ConfigurableNavigationHandler");
            return null;
        }

        public Map<String, Set<NavigationCase>> getNavigationCases() {
            log.warning(this.handler + " is not a ConfigurableNavigationHandler");
            return null;
        }

        public void handleNavigation(FacesContext context, String fromAction, String outcome) {
            this.handler.handleNavigation(context, fromAction, outcome);
        }
    }
}

