/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.jwi.item;

import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.POS;
import edu.mit.jwi.item.Synset;

public class SynsetID
implements ISynsetID {
    public static final String synsetIDPrefix = "SID-";
    private final int offset;
    private final POS pos;

    public SynsetID(int offset, POS pos) {
        if (pos == null) {
            throw new NullPointerException();
        }
        Synset.checkOffset(offset);
        this.offset = offset;
        this.pos = pos;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public POS getPOS() {
        return this.pos;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.offset;
        result = 31 * result + this.pos.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ISynsetID)) {
            return false;
        }
        ISynsetID other = (ISynsetID)obj;
        if (this.offset != other.getOffset()) {
            return false;
        }
        return this.pos.equals((Object)other.getPOS());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(14);
        sb.append(synsetIDPrefix);
        sb.append(Synset.zeroFillOffset(this.offset));
        sb.append('-');
        sb.append(Character.toUpperCase(this.pos.getTag()));
        return sb.toString();
    }

    public static SynsetID parseSynsetID(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if ((value = value.trim()).length() != 14) {
            throw new IllegalArgumentException();
        }
        if (!value.startsWith(synsetIDPrefix)) {
            throw new IllegalArgumentException();
        }
        int offset = Integer.parseInt(value.substring(4, 12));
        char tag = Character.toLowerCase(value.charAt(13));
        POS pos = POS.getPartOfSpeech(tag);
        if (pos == null) {
            throw new IllegalArgumentException("unknown part of speech tag: " + tag);
        }
        return new SynsetID(offset, pos);
    }
}

