/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.textspan;

import java.util.Collection;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.dictionary.lookup2.textspan.TextSpan;

@Immutable
public final class MultiTextSpan
implements TextSpan {
    private final int _start;
    private final int _end;
    private final Collection<TextSpan> _missingSpans;
    private final int _hashCode;

    public MultiTextSpan(int start, int end, Collection<TextSpan> missingSpans) {
        this._start = start;
        this._end = end;
        this._missingSpans = missingSpans;
        this._hashCode = 1000 * this._end + this._start + missingSpans.hashCode();
    }

    @Override
    public int getStart() {
        return this._start;
    }

    @Override
    public int getEnd() {
        return this._end;
    }

    @Override
    public int getLength() {
        int length = this._end - this._start + 1;
        for (TextSpan missingSpan : this._missingSpans) {
            length -= missingSpan.getLength();
        }
        return length;
    }

    public Collection<TextSpan> getMissingSpans() {
        return this._missingSpans;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object object) {
        return object instanceof MultiTextSpan && this._start == ((MultiTextSpan)object)._start && this._end == ((MultiTextSpan)object)._end && this._missingSpans.equals(((MultiTextSpan)object)._missingSpans);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Discontiguous TextSpan for span ").append(this._start).append(" to ").append(this._end);
        stringBuilder.append(" but missing:\n");
        for (TextSpan textSpan : this._missingSpans) {
            stringBuilder.append("   ").append(textSpan.toString()).append('\n');
        }
        return stringBuilder.toString();
    }
}

