/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.dictionary;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;
import org.apache.ctakes.dictionary.lookup2.dictionary.JdbcRareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.term.RareWordTerm;
import org.apache.ctakes.dictionary.lookup2.util.FastLookupToken;
import org.apache.ctakes.dictionary.lookup2.util.UmlsUserApprover;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public final class UmlsJdbcRareWordDictionary
implements RareWordDictionary {
    private static final Logger LOGGER = Logger.getLogger((String)"UmlsJdbcRareWordDictionary");
    private final RareWordDictionary _delegateDictionary;

    public UmlsJdbcRareWordDictionary(String name, UimaContext uimaContext, Properties properties) throws SQLException {
        boolean isValidUser = UmlsUserApprover.getInstance().isValidUMLSUser(uimaContext, properties);
        if (!isValidUser) {
            throw new SQLException("Invalid User for UMLS dictionary " + name);
        }
        this._delegateDictionary = new JdbcRareWordDictionary(name, uimaContext, properties);
    }

    @Override
    public String getName() {
        return this._delegateDictionary.getName();
    }

    @Override
    public Collection<RareWordTerm> getRareWordHits(FastLookupToken fastLookupToken) {
        return this._delegateDictionary.getRareWordHits(fastLookupToken);
    }

    @Override
    public Collection<RareWordTerm> getRareWordHits(String rareWordText) {
        return this._delegateDictionary.getRareWordHits(rareWordText);
    }
}

