/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.concept;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.core.util.collection.HashSetMap;
import org.apache.ctakes.core.util.collection.ImmutableCollectionMap;
import org.apache.ctakes.dictionary.lookup2.concept.Concept;
import org.apache.ctakes.dictionary.lookup2.util.SemanticUtil;

@Immutable
public final class DefaultConcept
implements Concept {
    private final String _cui;
    private final String _preferredText;
    private final CollectionMap<String, String, ? extends Collection<String>> _codes;
    private final Collection<Integer> _ctakesSemantics;
    private final int _hashcode;

    public DefaultConcept(String cui) {
        this(cui, "");
    }

    public DefaultConcept(String cui, String preferredText) {
        this(cui, preferredText, (CollectionMap<String, String, ? extends Collection<String>>)new HashSetMap());
    }

    public DefaultConcept(String cui, String preferredText, CollectionMap<String, String, ? extends Collection<String>> codes) {
        this._cui = cui;
        this._preferredText = preferredText;
        this._codes = new ImmutableCollectionMap(codes);
        Collection ctakesSemantics = this.getCodes("TUI").stream().map(SemanticUtil::getTuiSemanticGroupId).collect(Collectors.toSet());
        if (ctakesSemantics.isEmpty()) {
            ctakesSemantics.add(0);
        }
        this._ctakesSemantics = Collections.unmodifiableCollection(ctakesSemantics);
        this._hashcode = cui.hashCode();
    }

    @Override
    public String getCui() {
        return this._cui;
    }

    @Override
    public String getPreferredText() {
        if (this._preferredText != null) {
            return this._preferredText;
        }
        return "Unknown Preferred Term";
    }

    @Override
    public Collection<String> getCodeNames() {
        return this._codes.keySet();
    }

    @Override
    public Collection<String> getCodes(String codeType) {
        return this._codes.getCollection((Object)codeType);
    }

    @Override
    public Collection<Integer> getCtakesSemantics() {
        return this._ctakesSemantics;
    }

    @Override
    public boolean isEmpty() {
        return (this._preferredText == null || this._preferredText.isEmpty()) && this._codes.isEmpty();
    }

    public boolean equals(Object value) {
        return value instanceof Concept && this._cui.equals(((DefaultConcept)value)._cui);
    }

    public int hashCode() {
        return this._hashcode;
    }
}

