/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.ae;

import java.io.IOException;
import java.io.InputStream;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.dictionary.lookup2.ae.DefaultJCasTermAnnotator;
import org.apache.ctakes.dictionary.lookup2.ae.OverlapJCasTermAnnotator;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;

public final class DictionaryLookupFactory {
    private DictionaryLookupFactory() {
    }

    public static AnalysisEngineDescription createDefaultDictionaryLookupDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(DefaultJCasTermAnnotator.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription createCustomDictionaryLookupDescription(String descriptorPath) throws ResourceInitializationException {
        DictionaryLookupFactory.checkDescriptorPath(descriptorPath);
        return AnalysisEngineFactory.createEngineDescription(DefaultJCasTermAnnotator.class, (Object[])new Object[]{"DictionaryDescriptor", descriptorPath});
    }

    public static AnalysisEngineDescription createOverlapDictionaryLookupDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(OverlapJCasTermAnnotator.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription createCustomOverlapDictionaryLookupDescription(String descriptorPath) throws ResourceInitializationException {
        DictionaryLookupFactory.checkDescriptorPath(descriptorPath);
        return AnalysisEngineFactory.createEngineDescription(OverlapJCasTermAnnotator.class, (Object[])new Object[]{"DictionaryDescriptor", descriptorPath});
    }

    private static void checkDescriptorPath(String descriptorPath) throws ResourceInitializationException {
        try (InputStream descriptorStream = FileLocator.getAsStream((String)descriptorPath);){
            if (descriptorStream == null) {
                throw new ResourceInitializationException((Throwable)new IOException("Cannot open " + descriptorPath + " as stream"));
            }
        }
        catch (IOException ioE) {
            throw new ResourceInitializationException((Throwable)ioE);
        }
    }
}

