/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.ae;

import java.util.Collection;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.dictionary.lookup2.ae.AbstractJCasTermAnnotator;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.term.RareWordTerm;
import org.apache.ctakes.dictionary.lookup2.textspan.DefaultTextSpan;
import org.apache.ctakes.dictionary.lookup2.textspan.TextSpan;
import org.apache.ctakes.dictionary.lookup2.util.FastLookupToken;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="Dictionary Lookup (Default)", description="Annotates clinically-relevant terms.  Terms must match dictionary entries exactly.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN}, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public final class DefaultJCasTermAnnotator
extends AbstractJCasTermAnnotator {
    @Override
    public void findTerms(RareWordDictionary dictionary, List<FastLookupToken> allTokens, List<Integer> lookupTokenIndices, CollectionMap<TextSpan, Long, ? extends Collection<Long>> termsFromDictionary) {
        for (Integer lookupTokenIndex : lookupTokenIndices) {
            FastLookupToken lookupToken = allTokens.get(lookupTokenIndex);
            Collection<RareWordTerm> rareWordHits = dictionary.getRareWordHits(lookupToken);
            if (rareWordHits == null || rareWordHits.isEmpty()) continue;
            for (RareWordTerm rareWordHit : rareWordHits) {
                int termEndIndex;
                if (rareWordHit.getText().length() < this._minimumLookupSpan) continue;
                if (rareWordHit.getTokenCount() == 1) {
                    termsFromDictionary.placeValue((Object)lookupToken.getTextSpan(), (Object)rareWordHit.getCuiCode());
                    continue;
                }
                int termStartIndex = lookupTokenIndex - rareWordHit.getRareWordIndex();
                if (termStartIndex < 0 || termStartIndex + rareWordHit.getTokenCount() > allTokens.size() || !DefaultJCasTermAnnotator.isTermMatch(rareWordHit, allTokens, termStartIndex, termEndIndex = termStartIndex + rareWordHit.getTokenCount() - 1)) continue;
                int spanStart = allTokens.get(termStartIndex).getStart();
                int spanEnd = allTokens.get(termEndIndex).getEnd();
                termsFromDictionary.placeValue((Object)new DefaultTextSpan(spanStart, spanEnd), (Object)rareWordHit.getCuiCode());
            }
        }
    }

    public static boolean isTermMatch(RareWordTerm rareWordHit, List<FastLookupToken> allTokens, int termStartIndex, int termEndIndex) {
        String[] hitTokens = rareWordHit.getTokens();
        int hit = 0;
        for (int i = termStartIndex; i < termEndIndex + 1; ++i) {
            if (hitTokens[hit].equals(allTokens.get(i).getText()) || hitTokens[hit].equals(allTokens.get(i).getVariant())) {
                ++hit;
                continue;
            }
            return false;
        }
        return true;
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(DefaultJCasTermAnnotator.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String descriptorPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(DefaultJCasTermAnnotator.class, (Object[])new Object[]{"DictionaryDescriptor", descriptorPath});
    }
}

