/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util;

import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;

public class ListFactory {
    public static FSList buildList(JCas jcas, TOP[] objArr) {
        NonEmptyFSList firstList;
        if (objArr.length == 0) {
            return new EmptyFSList(jcas);
        }
        NonEmptyFSList list = firstList = new NonEmptyFSList(jcas);
        for (int i = 0; i < objArr.length; ++i) {
            list.setHead(objArr[i]);
            list.addToIndexes();
            if (i + 1 >= objArr.length) continue;
            NonEmptyFSList nextList = new NonEmptyFSList(jcas);
            list.setTail((FSList)nextList);
            list = nextList;
        }
        list.setTail((FSList)new EmptyFSList(jcas));
        return firstList;
    }

    public static FSList buildList(JCas jcas, List<? extends TOP> objArr) {
        return ListFactory.buildList(jcas, objArr.toArray(new TOP[0]));
    }

    public static void append(JCas jcas, FSList list, TOP element) {
        if (list instanceof EmptyFSList) {
            return;
        }
        NonEmptyFSList cur = (NonEmptyFSList)list;
        while (cur.getTail() instanceof NonEmptyFSList) {
            cur = (NonEmptyFSList)cur.getTail();
        }
        NonEmptyFSList newElList = new NonEmptyFSList(jcas);
        newElList.setHead(element);
        newElList.setTail((FSList)new EmptyFSList(jcas));
        cur.setTail((FSList)newElList);
        newElList.addToIndexes();
        newElList.getTail().addToIndexes();
    }
}

