/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;

@Immutable
public final class PipeBitInfoUtil {
    private static final Logger LOGGER = Logger.getLogger((String)"PipeBitInfoUtil");
    private static final String UNKNOWN_PIPE_BIT = "! Unfamiliar";

    private PipeBitInfoUtil() {
    }

    public static String getName(Class<?> pipeBitClass) {
        return PipeBitInfoUtil.getInfo(pipeBitClass).name();
    }

    public static PipeBitInfo getInfo(Class<?> pipeBitClass) {
        PipeBitInfo info = pipeBitClass.getAnnotation(PipeBitInfo.class);
        if (info == null) {
            return new AutoPipeBitInfo(pipeBitClass);
        }
        return info;
    }

    public static Collection<PipeBitInfo> getAllInfos(Class<?> pipeBitClass) {
        List<PipeBitInfo> infos = PipeBitInfoUtil.getSuperInfos(pipeBitClass.getSuperclass());
        infos.add(0, PipeBitInfoUtil.getInfo(pipeBitClass));
        return infos;
    }

    private static List<PipeBitInfo> getSuperInfos(Class<?> pipeBitClass) {
        if (pipeBitClass == null || pipeBitClass.equals(CollectionReader_ImplBase.class) || pipeBitClass.equals(JCasAnnotator_ImplBase.class) || pipeBitClass.equals(CasConsumer_ImplBase.class)) {
            return Collections.emptyList();
        }
        ArrayList<PipeBitInfo> infos = new ArrayList<PipeBitInfo>();
        PipeBitInfo info = pipeBitClass.getAnnotation(PipeBitInfo.class);
        if (info != null) {
            infos.add(info);
        }
        infos.addAll(PipeBitInfoUtil.getSuperInfos(pipeBitClass.getSuperclass()));
        return infos;
    }

    public static Collection<ConfigurationParameter> getAllParameters(Class<?> pipeBitClass) {
        if (pipeBitClass == null || pipeBitClass.equals(CollectionReader_ImplBase.class) || pipeBitClass.equals(JCasAnnotator_ImplBase.class) || pipeBitClass.equals(CasConsumer_ImplBase.class)) {
            return Collections.emptyList();
        }
        Field[] fields = pipeBitClass.getDeclaredFields();
        Collection parameters = Arrays.stream(fields).map(f -> f.getAnnotation(ConfigurationParameter.class)).filter(Objects::nonNull).collect(Collectors.toList());
        parameters.addAll(PipeBitInfoUtil.getAllParameters(pipeBitClass.getSuperclass()));
        return parameters;
    }

    public static boolean isUnknown(PipeBitInfo info) {
        return info.description().startsWith(UNKNOWN_PIPE_BIT);
    }

    private static Collection<String> getParameterDescriptions(Class<?> pipeBitClass) {
        return PipeBitInfoUtil.getAllParameters(pipeBitClass).stream().map(p -> p.name() + " : " + p.description()).collect(Collectors.toList());
    }

    @Immutable
    private static final class AutoPipeBitInfo
    implements PipeBitInfo {
        private final Class<?> _pipeBitClass;

        private AutoPipeBitInfo(Class<?> pipeBitClass) {
            this._pipeBitClass = pipeBitClass;
        }

        @Override
        public String name() {
            return this._pipeBitClass.getSimpleName();
        }

        @Override
        public String description() {
            String purpose = "Has an unknown purpose.";
            if (CollectionReader_ImplBase.class.isAssignableFrom(this._pipeBitClass)) {
                purpose = "Reads or creates Text and provides it to a pipeline.";
            } else if (JCasAnnotator_ImplBase.class.isAssignableFrom(this._pipeBitClass)) {
                purpose = "Performs some Annotation task within a pipeline.";
            } else if (CasConsumer_ImplBase.class.isAssignableFrom(this._pipeBitClass)) {
                purpose = "Consumes Annotations and performs some task at the end of a pipeline.";
            }
            return "! Unfamiliar " + this.name() + " : " + purpose + "  Use with care.";
        }

        @Override
        public PipeBitInfo.Role role() {
            if (CollectionReader_ImplBase.class.isAssignableFrom(this._pipeBitClass)) {
                return PipeBitInfo.Role.READER;
            }
            if (CasConsumer_ImplBase.class.isAssignableFrom(this._pipeBitClass)) {
                return PipeBitInfo.Role.WRITER;
            }
            return PipeBitInfo.Role.ANNOTATOR;
        }

        @Override
        public String[] parameters() {
            Collection parameters = PipeBitInfoUtil.getParameterDescriptions(this._pipeBitClass);
            return parameters.toArray(new String[parameters.size()]);
        }

        @Override
        public PipeBitInfo.TypeProduct[] dependencies() {
            return NO_TYPE_PRODUCTS;
        }

        @Override
        public PipeBitInfo.TypeProduct[] usables() {
            return NO_TYPE_PRODUCTS;
        }

        @Override
        public PipeBitInfo.TypeProduct[] products() {
            return NO_TYPE_PRODUCTS;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return PipeBitInfo.class;
        }
    }
}

