/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.structured.DocumentIdPrefix;
import org.apache.ctakes.typesystem.type.structured.DocumentPath;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

@PipeBitInfo(name="Files in Dir Tree Reader", description="Reads document texts from text files in a directory tree.", role=PipeBitInfo.Role.READER, products={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.DOCUMENT_ID_PREFIX})
public final class FileTreeReader
extends JCasCollectionReader_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"FileTreeReader");
    @ConfigurationParameter(name="InputDirectory", description="Directory for all input files.")
    private String _rootDirPath;
    public static final String PARAM_ENCODING = "Encoding";
    @ConfigurationParameter(name="Encoding", description="The character encoding used by the input files.", mandatory=false)
    private String _encoding;
    public static final String PARAM_EXTENSIONS = "Extensions";
    @ConfigurationParameter(name="Extensions", description="The extensions of the files that the collection reader will read.  Values for this parameter should not begin with a dot.", mandatory=false)
    private String[] _explicitExtensions;
    private File _rootDir;
    private Collection<String> _validExtensions;
    private List<File> _files;
    private int _currentIndex;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        try {
            this._rootDir = FileLocator.locateFile(this._rootDirPath);
        }
        catch (FileNotFoundException fnfE) {
            throw new ResourceInitializationException((Throwable)fnfE);
        }
        this._validExtensions = FileTreeReader.createValidExtensions(this._explicitExtensions);
        this._currentIndex = 0;
        this._files = FileTreeReader.getDescendentFiles(this._rootDir, this._validExtensions);
    }

    static Collection<String> createValidExtensions(String ... explicitExtensions) {
        if (explicitExtensions == null || explicitExtensions.length == 0) {
            return Collections.emptyList();
        }
        if (explicitExtensions.length == 1 && (explicitExtensions[0].equals("*") || explicitExtensions[0].equals(".*"))) {
            return Collections.emptyList();
        }
        ArrayList<String> validExtensions = new ArrayList<String>(explicitExtensions.length);
        for (String extension : explicitExtensions) {
            if (extension.startsWith(".")) {
                validExtensions.add(extension);
                continue;
            }
            validExtensions.add('.' + extension);
        }
        return validExtensions;
    }

    private static List<File> getDescendentFiles(File parentDir, Collection<String> validExtensions) {
        File[] children = parentDir.listFiles();
        if (children == null || children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> childDirs = new ArrayList<File>();
        ArrayList<File> descendentFiles = new ArrayList<File>();
        for (File child : children) {
            if (child.isDirectory()) {
                childDirs.add(child);
                continue;
            }
            if (!FileTreeReader.isExtensionValid(child, validExtensions) || child.isHidden()) continue;
            descendentFiles.add(child);
        }
        for (File childDir : childDirs) {
            descendentFiles.addAll(FileTreeReader.getDescendentFiles(childDir, validExtensions));
        }
        return descendentFiles;
    }

    static boolean isExtensionValid(File file, Collection<String> validExtensions) {
        if (validExtensions.isEmpty()) {
            return true;
        }
        String fileName = file.getName();
        for (String extension : validExtensions) {
            if (!fileName.endsWith(extension)) continue;
            if (fileName.equals(extension)) {
                LOGGER.warn((Object)("File " + file.getPath() + " is named as extension " + extension + " ; discarded"));
                return false;
            }
            return true;
        }
        return false;
    }

    static String createDocumentID(File file, Collection<String> validExtensions) {
        String fileName = file.getName();
        String maxExtension = "";
        for (String extension : validExtensions) {
            if (!fileName.endsWith(extension) || extension.length() <= maxExtension.length()) continue;
            maxExtension = extension;
        }
        int lastDot = fileName.lastIndexOf(46);
        if (!maxExtension.isEmpty()) {
            lastDot = fileName.length() - maxExtension.length();
        }
        if (lastDot < 0) {
            return fileName;
        }
        return fileName.substring(0, lastDot);
    }

    private static String createDocumentIdPrefix(File file, File rootDir) {
        String rootPath;
        String parentPath = file.getParent();
        if (parentPath.equals(rootPath = rootDir.getPath()) || !parentPath.startsWith(rootPath)) {
            return "";
        }
        return parentPath.substring(rootPath.length() + 1);
    }

    public int getNumberOfDocuments() {
        return this._files.size();
    }

    public boolean hasNext() {
        return this._currentIndex < this._files.size();
    }

    public void getNext(JCas jcas) throws IOException, CollectionException {
        File file = this._files.get(this._currentIndex);
        ++this._currentIndex;
        byte[] buffer = new byte[8192];
        StringBuilder sb = new StringBuilder();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file), buffer.length);){
            int length;
            while ((length = ((InputStream)inputStream).read(buffer)) >= 0) {
                if (this._encoding != null) {
                    sb.append(new String(buffer, 0, length, this._encoding));
                    continue;
                }
                sb.append(new String(buffer, 0, length));
            }
        }
        catch (FileNotFoundException fnfE) {
            throw new IOException(fnfE);
        }
        jcas.setDocumentText(sb.toString());
        DocumentID documentId = new DocumentID(jcas);
        String id = FileTreeReader.createDocumentID(file, this._validExtensions);
        documentId.setDocumentID(id);
        documentId.addToIndexes();
        DocumentIdPrefix documentIdPrefix = new DocumentIdPrefix(jcas);
        String idPrefix = FileTreeReader.createDocumentIdPrefix(file, this._rootDir);
        documentIdPrefix.setDocumentIdPrefix(idPrefix);
        documentIdPrefix.addToIndexes();
        DocumentPath documentPath = new DocumentPath(jcas);
        documentPath.setDocumentPath(file.getAbsolutePath());
        documentPath.addToIndexes();
    }

    public void close() throws IOException {
    }

    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this._currentIndex, this._files.size(), "entities")};
    }

    public static CollectionReader createReader(String inputDirectory) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader(FileTreeReader.class, (Object[])new Object[]{"InputDirectory", inputDirectory});
    }
}

