/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc.pretty.cell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.cc.pretty.SemanticGroup;
import org.apache.ctakes.core.cc.pretty.cell.AbstractItemCell;
import org.apache.ctakes.core.cc.pretty.cell.UmlsItemCell;
import org.apache.ctakes.core.cc.pretty.textspan.TextSpan;

public final class DefaultUmlsItemCell
extends AbstractItemCell
implements UmlsItemCell {
    private static final int CUI_SPAN = 8;
    private static final String NEGATED_TEXT = "Negated";
    private final int _semanticWidth;
    private final int _height;
    private final boolean _negated;
    private final List<String> _semanticTextLines;

    private static Collection<String> getSortedSemanticNames(Collection<String> semanticCuiNames) {
        ArrayList<String> semanticGroupNames = new ArrayList<String>();
        for (SemanticGroup semanticGroup : SemanticGroup.values()) {
            semanticGroupNames.add(semanticGroup.getName());
        }
        ArrayList<String> sortedCuiNames = new ArrayList<String>(semanticCuiNames);
        semanticGroupNames.retainAll(sortedCuiNames);
        sortedCuiNames.removeAll(semanticGroupNames);
        Collections.sort(sortedCuiNames);
        semanticGroupNames.addAll(sortedCuiNames);
        return semanticGroupNames;
    }

    public DefaultUmlsItemCell(TextSpan textSpan, int polarity, Map<String, Collection<String>> semanticCuis) {
        super(textSpan);
        int width = 8;
        this._negated = polarity < 0;
        this._semanticTextLines = new ArrayList<String>();
        ArrayList<String> sortedCuis = new ArrayList<String>();
        Collection<String> semanticGroupNames = DefaultUmlsItemCell.getSortedSemanticNames(semanticCuis.keySet());
        for (String semanticName : semanticGroupNames) {
            Collection<String> cuis = semanticCuis.get(semanticName);
            if (cuis == null) continue;
            width = Math.max(width, semanticName.length());
            this._semanticTextLines.add(semanticName);
            sortedCuis.addAll(cuis);
            Collections.sort(sortedCuis);
            this._semanticTextLines.addAll(sortedCuis);
            sortedCuis.clear();
        }
        this._semanticWidth = width;
        int height = 1 + this._semanticTextLines.size();
        if (this._negated) {
            ++height;
        }
        this._height = height;
    }

    @Override
    public int getWidth() {
        return Math.max(this.getTextSpan().getWidth(), this._semanticWidth);
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public String getText() {
        return "ENTITY_FILL";
    }

    @Override
    public boolean isNegated() {
        return this._negated;
    }

    @Override
    public String getLineText(int lineIndex) {
        if (lineIndex == 0) {
            return "ENTITY_FILL";
        }
        if (lineIndex > 0 && lineIndex - 1 < this._semanticTextLines.size()) {
            return this._semanticTextLines.get(lineIndex - 1);
        }
        if (this.isNegated() && lineIndex - 1 == this._semanticTextLines.size()) {
            return NEGATED_TEXT;
        }
        return "";
    }

    public boolean equals(Object other) {
        return other instanceof DefaultUmlsItemCell && this.getTextSpan().equals(((DefaultUmlsItemCell)other).getTextSpan()) && this.isNegated() == ((DefaultUmlsItemCell)other).isNegated() && this._semanticTextLines.equals(((DefaultUmlsItemCell)other)._semanticTextLines);
    }

    public int hashCode() {
        return 2 * this.getTextSpan().hashCode() + 2 * this._semanticTextLines.hashCode() + (this.isNegated() ? 1 : 0);
    }
}

