/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.core.util.OntologyConceptUtil;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.CasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

@PipeBitInfo(name="CUI Count Writer", description="Writes a two-column BSV file containing CUIs and their total counts in a document.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class CuiCountFileWriter
extends CasConsumer_ImplBase {
    private static final Logger LOGGER = Logger.getLogger((String)"CuiCountFileWriter");
    private static final String FILE_EXTENSION = ".cuicount.bsv";
    @ConfigurationParameter(name="OutputDirectory", mandatory=false, description="Directory for all output files.", defaultValue={""})
    private String fitOutputDirectoryPath;
    private String _outputDirPath;

    public void initialize(UimaContext uimaContext) throws ResourceInitializationException {
        super.initialize(uimaContext);
        try {
            if (this.fitOutputDirectoryPath == null) {
                this.fitOutputDirectoryPath = (String)uimaContext.getConfigParameterValue("OutputDirectory");
            }
            if (this.fitOutputDirectoryPath != null) {
                this.setOutputDirectory(this.fitOutputDirectoryPath);
            }
        }
        catch (IllegalArgumentException | SecurityException multE) {
            throw new ResourceInitializationException((Throwable)multE);
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException casE) {
            throw new AnalysisEngineProcessException((Throwable)casE);
        }
        this.process(jcas);
    }

    public void setOutputDirectory(String outputDirectoryPath) throws IllegalArgumentException, SecurityException {
        if (outputDirectoryPath == null || outputDirectoryPath.isEmpty()) {
            this._outputDirPath = "";
            LOGGER.debug((Object)("No Output Directory Path specified, using current working directory " + System.getProperty("user.dir")));
            return;
        }
        File outputDir = new File(outputDirectoryPath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException(outputDirectoryPath + " is not a valid directory path");
        }
        this._outputDirPath = outputDirectoryPath;
        LOGGER.debug((Object)("Output Directory Path set to " + this._outputDirPath));
    }

    public void process(JCas jcas) {
        LOGGER.info((Object)"Starting processing");
        String docId = DocumentIDAnnotationUtil.getDocumentIdForFile(jcas);
        File outputFile = this._outputDirPath == null || this._outputDirPath.isEmpty() ? new File(docId + FILE_EXTENSION) : new File(this._outputDirPath, docId + FILE_EXTENSION);
        Map positiveCounts = JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class).stream().filter(a -> a.getPolarity() != -1).map(OntologyConceptUtil::getCuis).flatMap(Collection::stream).sorted().collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, c -> 1, Integer::sum)));
        Map negativeCounts = JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class).stream().filter(a -> a.getPolarity() == -1).map(OntologyConceptUtil::getCuis).flatMap(Collection::stream).sorted().collect(Collectors.groupingBy(Function.identity(), Collectors.reducing(0, c -> 1, Integer::sum)));
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            for (Map.Entry cuiCount : positiveCounts.entrySet()) {
                writer.write((String)cuiCount.getKey() + "|" + cuiCount.getValue() + "\n");
            }
            for (Map.Entry cuiCount : negativeCounts.entrySet()) {
                writer.write("-" + (String)cuiCount.getKey() + "|" + cuiCount.getValue() + "\n");
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)("Could not not write cui count file " + outputFile.getPath()));
            LOGGER.error((Object)ioE.getMessage());
        }
        LOGGER.info((Object)"Finished processing");
    }
}

