/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.utils;

public class JSONBuilder {
    private StringBuilder params = new StringBuilder();

    public static JSONBuilder create() {
        return new JSONBuilder();
    }

    public JSONBuilder beginMap() {
        this.params.append("{");
        return this;
    }

    public JSONBuilder beginMap(String key) {
        this.appendCommaAndKey(key);
        return this.beginMap();
    }

    public JSONBuilder endMap() {
        this.params.append("}");
        return this;
    }

    public JSONBuilder beginArray(String key) {
        this.appendCommaAndKey(key);
        this.params.append("[");
        return this;
    }

    public JSONBuilder endArray() {
        this.params.append("]");
        return this;
    }

    public JSONBuilder entry(String key, int value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, long value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, float value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, double value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, boolean value) {
        this.appendCommaAndKey(key);
        this.params.append(value);
        return this;
    }

    public JSONBuilder entry(String key, String[] keyValuePairs) {
        this.beginArray(key);
        int argCount = keyValuePairs.length / 2;
        StringBuilder localCopy = new StringBuilder();
        for (int idx = 0; idx < argCount; ++idx) {
            localCopy.append('\"').append(JSONBuilder.escapeString(keyValuePairs[2 * idx])).append('\"').append(",").append('\"').append(JSONBuilder.escapeString(keyValuePairs[2 * idx + 1])).append('\"');
            localCopy.append(",");
        }
        if (localCopy.length() > 0) {
            localCopy.setLength(localCopy.length() - 1);
        }
        this.params.append(localCopy.toString());
        this.endArray();
        return this;
    }

    public JSONBuilder entry(String key, String value) {
        return this.entry(key, value, false);
    }

    public JSONBuilder entry(String key, String value, boolean isStringLiteral) {
        this.appendCommaAndKey(key);
        if (isStringLiteral) {
            this.params.append(value);
        } else {
            value = JSONBuilder.escapeString(value);
            this.params.append('\"').append(value).append('\"');
        }
        return this;
    }

    public JSONBuilder item(String value) {
        this.conditionallyAppendComma();
        value = JSONBuilder.escapeString(value);
        this.params.append('\"').append(value).append('\"');
        return this;
    }

    public static String escapeString(String value) {
        StringBuilder sb = new StringBuilder();
        block10: for (int idx = 0; idx < value.length(); ++idx) {
            char c = value.charAt(idx);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.params.toString();
    }

    private void appendCommaAndKey(String key) {
        this.conditionallyAppendComma();
        this.params.append('\"').append(key).append('\"').append(":");
    }

    private void conditionallyAppendComma() {
        char lastChar = this.params.charAt(this.params.length() - 1);
        if (lastChar != '{' && lastChar != '[') {
            this.params.append(",");
        }
    }
}

