/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.lang.annotation.ElementType;
import java.util.LinkedHashSet;
import org.apache.commons.weaver.model.ScanRequest;
import org.apache.commons.weaver.model.Scanner;
import org.apache.commons.weaver.model.WeavableClass;
import org.apache.commons.weaver.model.WeaveEnvironment;
import org.apache.commons.weaver.model.WeaveInterest;
import org.apache.commons.weaver.privilizer.Policy;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizer;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.apache.commons.weaver.privilizer._lang3.Validate;
import org.apache.commons.weaver.spi.Weaver;

public class PrivilizerWeaver
implements Weaver {
    public boolean process(WeaveEnvironment weaveEnvironment, Scanner scanner) {
        Class target;
        Privilizer privilizer = new Privilizer(weaveEnvironment);
        LinkedHashSet<Class> privilizedTypes = new LinkedHashSet<Class>();
        for (WeavableClass type : scanner.scan(new ScanRequest().add(WeaveInterest.of(Privilizing.class, (ElementType)ElementType.TYPE))).getClasses()) {
            target = (Class)type.getTarget();
            if (!privilizedTypes.add(target) || !this.validateRequest(privilizer, type)) continue;
            privilizer.blueprint(target, (Privilizing)type.getAnnotation(Privilizing.class));
        }
        for (WeavableClass type : scanner.scan(new ScanRequest().add(WeaveInterest.of(Privileged.class, (ElementType)ElementType.METHOD))).getClasses()) {
            target = (Class)type.getTarget();
            if (!privilizedTypes.add(target) || !this.validateRequest(privilizer, type)) continue;
            privilizer.privilize(target);
        }
        return !privilizedTypes.isEmpty();
    }

    private boolean validateRequest(Privilizer privilizer, WeavableClass<?> type) {
        Privilized marker = (Privilized)type.getAnnotation(Privilized.class);
        if (marker == null) {
            return privilizer.policy != Policy.NEVER;
        }
        Validate.validState(privilizer.policy.name().equals(marker.value()), "%s already privilized with policy %s", ((Class)type.getTarget()).getName(), marker.value());
        return false;
    }
}

