/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PoolUtils;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.TestGenericKeyedObjectPool;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

class TestPoolUtils {
    private static final int CHECK_PERIOD = 300;
    private static final int CHECK_COUNT = 4;
    private static final int CHECK_SLEEP_PERIOD = 1050;

    TestPoolUtils() {
    }

    private static <T> T createProxy(Class<T> clazz, InvocationHandler handler) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    private static <T> T createProxy(Class<T> clazz, List<String> logger) {
        return TestPoolUtils.createProxy(clazz, new MethodCallLogger(logger));
    }

    private static List<String> invokeEveryMethod(KeyedObjectPool<Object, Object> kop) throws Exception {
        kop.addObject(null);
        kop.borrowObject(null);
        kop.clear();
        kop.clear(null);
        kop.close();
        kop.getKeys();
        kop.getNumActive();
        kop.getNumActive(null);
        kop.getNumIdle();
        kop.getNumIdle(null);
        kop.invalidateObject(null, new Object());
        kop.returnObject(null, new Object());
        kop.toString();
        return Arrays.asList("addObject", "borrowObject", "clear", "clear", "close", "getKeys", "getNumActive", "getNumActive", "getNumIdle", "getNumIdle", "invalidateObject", "returnObject", "toString");
    }

    private static <K, V> List<String> invokeEveryMethod(KeyedPooledObjectFactory<K, V> kpof) throws Exception {
        kpof.activateObject(null, null);
        kpof.destroyObject(null, null);
        kpof.makeObject(null);
        kpof.passivateObject(null, null);
        kpof.validateObject(null, null);
        kpof.toString();
        return Arrays.asList("activateObject", "destroyObject", "makeObject", "passivateObject", "validateObject", "toString");
    }

    private static List<String> invokeEveryMethod(ObjectPool<Object> op) throws Exception {
        op.addObject();
        op.borrowObject();
        op.clear();
        op.close();
        op.getNumActive();
        op.getNumIdle();
        op.invalidateObject(new Object());
        op.returnObject(new Object());
        op.toString();
        return Arrays.asList("addObject", "borrowObject", "clear", "close", "getNumActive", "getNumIdle", "invalidateObject", "returnObject", "toString");
    }

    private static <T> List<String> invokeEveryMethod(PooledObjectFactory<T> pof) throws Exception {
        pof.activateObject(null);
        pof.destroyObject(null);
        pof.makeObject();
        pof.passivateObject(null);
        pof.validateObject(null);
        pof.toString();
        return Arrays.asList("activateObject", "destroyObject", "makeObject", "passivateObject", "validateObject", "toString");
    }

    @Test
    void testCheckMinIdleKeyedObjectPool() throws InterruptedException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.checkMinIdle(null, (Object)new Object(), (int)1, (long)1L), (String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not allow null pool.");
        try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.checkMinIdle((KeyedObjectPool)pool, null, (int)1, (long)1L), (String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not accept null keys.");
        }
        pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.checkMinIdle((KeyedObjectPool)pool, (Object)new Object(), (int)-1, (long)1L), (String)"PoolUtils.checkMinIdle(KeyedObjectPool,Object,int,long) must not accept negative min idle values.");
        }
        finally {
            if (pool != null) {
                pool.close();
            }
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        Object key = new Object();
        KeyedPooledObjectFactory kpof = TestPoolUtils.createProxy(KeyedPooledObjectFactory.class, calledMethods);
        try (GenericKeyedObjectPool kop = new GenericKeyedObjectPool(kpof);){
            PoolUtils.checkMinIdle((KeyedObjectPool)kop, (Object)key, (int)2, (long)100L);
            Thread.sleep(400L);
            Assertions.assertEquals((int)2, (int)kop.getNumIdle(key));
            Assertions.assertEquals((int)2, (int)kop.getNumIdle());
        }
        int makeObjectCount = 0;
        for (String methodName : calledMethods) {
            if (!"makeObject".equals(methodName)) continue;
            ++makeObjectCount;
        }
        Assertions.assertEquals((int)2, (int)makeObjectCount, (String)"makeObject should have been called two time");
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            try {
                calledMethods.clear();
                try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);){
                    TimerTask task = PoolUtils.checkMinIdle((KeyedObjectPool)pool, (Object)key, (int)1, (long)300L);
                    Thread.sleep(1050L);
                    task.cancel();
                    task.toString();
                    ArrayList<String> expectedMethods = new ArrayList<String>();
                    for (int i = 0; i < 4; ++i) {
                        expectedMethods.add("getNumIdle");
                        expectedMethods.add("addObject");
                    }
                    expectedMethods.add("toString");
                    Assertions.assertEquals(expectedMethods, calledMethods);
                }
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    void testCheckMinIdleKeyedObjectPoolKeys() throws InterruptedException {
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            ArrayList<String> calledMethods = new ArrayList<String>();
            try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);){
                ArrayList<String> keys = new ArrayList<String>(2);
                keys.add("one");
                keys.add("two");
                Map tasks = PoolUtils.checkMinIdle((KeyedObjectPool)pool, keys, (int)1, (long)300L);
                Thread.sleep(1050L);
                for (TimerTask task : tasks.values()) {
                    task.cancel();
                }
                ArrayList<String> expectedMethods = new ArrayList<String>();
                for (int i = 0; i < 4 * keys.size(); ++i) {
                    expectedMethods.add("getNumIdle");
                    expectedMethods.add("addObject");
                }
                Assertions.assertEquals(expectedMethods, calledMethods);
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    void testCheckMinIdleKeyedObjectPoolKeysNulls() {
        try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.checkMinIdle((KeyedObjectPool)pool, (Object)null, (int)1, (long)1L), (String)"PoolUtils.checkMinIdle(KeyedObjectPool,Collection,int,long) must not accept null keys.");
        }
        try {
            pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);
            try {
                PoolUtils.checkMinIdle((KeyedObjectPool)pool, Collections.emptyList(), (int)1, (long)1L);
            }
            finally {
                if (pool != null) {
                    pool.close();
                }
            }
        }
        catch (IllegalArgumentException iae) {
            Assertions.fail((String)"PoolUtils.checkMinIdle(KeyedObjectPool,Collection,int,long) must accept empty lists.");
        }
    }

    @Test
    void testCheckMinIdleObjectPool() throws InterruptedException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.checkMinIdle(null, (int)1, (long)1L), (String)"PoolUtils.checkMinIdle(ObjectPool,,) must not allow null pool.");
        try (ObjectPool pool = TestPoolUtils.createProxy(ObjectPool.class, (List<String>)null);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.checkMinIdle((ObjectPool)pool, (int)-1, (long)1L), (String)"PoolUtils.checkMinIdle(ObjectPool,,) must not accept negative min idle values.");
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        PooledObjectFactory pof = TestPoolUtils.createProxy(PooledObjectFactory.class, calledMethods);
        try (GenericObjectPool op = new GenericObjectPool(pof);){
            PoolUtils.checkMinIdle((ObjectPool)op, (int)2, (long)100L);
            Thread.sleep(1000L);
            Assertions.assertEquals((int)2, (int)op.getNumIdle());
        }
        int makeObjectCount = 0;
        for (String methodName : calledMethods) {
            if (!"makeObject".equals(methodName)) continue;
            ++makeObjectCount;
        }
        Assertions.assertEquals((int)2, (int)makeObjectCount, (String)"makeObject should have been called two time");
        AssertionFailedError afe = null;
        int triesLeft = 3;
        do {
            afe = null;
            try {
                calledMethods.clear();
                try (ObjectPool pool = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);){
                    TimerTask task = PoolUtils.checkMinIdle((ObjectPool)pool, (int)1, (long)300L);
                    Thread.sleep(1050L);
                    task.cancel();
                    task.toString();
                    ArrayList<String> expectedMethods = new ArrayList<String>();
                    for (int i = 0; i < 4; ++i) {
                        expectedMethods.add("getNumIdle");
                        expectedMethods.add("addObject");
                    }
                    expectedMethods.add("toString");
                    Assertions.assertEquals(expectedMethods, calledMethods);
                }
            }
            catch (AssertionFailedError e) {
                afe = e;
            }
        } while (--triesLeft > 0 && afe != null);
        if (afe != null) {
            throw afe;
        }
    }

    @Test
    void testCheckRethrow() {
        try {
            PoolUtils.checkRethrow((Throwable)new Exception());
        }
        catch (Throwable t) {
            Assertions.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow only ThreadDeath and VirtualMachineError.");
        }
        try {
            PoolUtils.checkRethrow((Throwable)new ThreadDeath());
            Assertions.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow ThreadDeath.");
        }
        catch (ThreadDeath t) {
        }
        catch (Throwable t) {
            Assertions.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow only ThreadDeath and VirtualMachineError.");
        }
        try {
            PoolUtils.checkRethrow((Throwable)new InternalError());
            Assertions.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow VirtualMachineError.");
        }
        catch (VirtualMachineError t) {
        }
        catch (Throwable t) {
            Assertions.fail((String)"PoolUtils.checkRethrow(Throwable) must rethrow only ThreadDeath and VirtualMachineError.");
        }
    }

    @Test
    void testErodingObjectPoolDefaultFactor() {
        try (ObjectPool internalPool = TestPoolUtils.createProxy(ObjectPool.class, (Object arg0, Method arg1, Object[] arg2) -> null);
             ObjectPool pool = PoolUtils.erodingPool((ObjectPool)internalPool);){
            String expectedToString = "ErodingObjectPool{factor=ErodingFactor{factor=1.0, idleHighWaterMark=1}, pool=" + internalPool + "}";
            Assertions.assertEquals((Object)expectedToString, (Object)pool.toString());
        }
    }

    @Test
    void testErodingPerKeyKeyedObjectPool() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true), (String)"PoolUtils.erodingPool(KeyedObjectPool) must not allow a null pool.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((KeyedObjectPool)null, (float)0.0f, (boolean)true), (String)"PoolUtils.erodingPool(ObjectPool, float, boolean) must not allow a non-positive factor.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true), (String)"PoolUtils.erodingPool(KeyedObjectPool, float, boolean) must not allow a null pool.");
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        float factor = 0.01f;
        try (KeyedObjectPool pool = PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)0.01f, (boolean)true);){
            ArrayList<String> expectedMethods = new ArrayList<String>();
            Assertions.assertEquals(expectedMethods, calledMethods);
            String key = "key";
            Object o = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            Assertions.assertEquals(expectedMethods, calledMethods);
            pool.returnObject((Object)key, o);
            expectedMethods.add("returnObject");
            Assertions.assertEquals(expectedMethods, calledMethods);
            for (int i = 0; i < 5; ++i) {
                o = pool.borrowObject((Object)key);
                expectedMethods.add("borrowObject");
                Thread.sleep(50L);
                pool.returnObject((Object)key, o);
                expectedMethods.add("returnObject");
                Assertions.assertEquals(expectedMethods, calledMethods);
                expectedMethods.clear();
                calledMethods.clear();
            }
            Thread.sleep(10000L);
            o = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            pool.returnObject((Object)key, o);
            expectedMethods.add("getNumIdle");
            expectedMethods.add("invalidateObject");
            Assertions.assertEquals(expectedMethods, calledMethods);
            String expectedToString = "ErodingPerKeyKeyedObjectPool{factor=0.01, keyedPool=null}";
            Assertions.assertEquals((Object)"ErodingPerKeyKeyedObjectPool{factor=0.01, keyedPool=null}", (Object)pool.toString());
        }
    }

    @Test
    void testErodingPoolKeyedObjectPool() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((KeyedObjectPool)null), (String)"PoolUtils.erodingPool(KeyedObjectPool) must not allow a null pool.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f), (String)"PoolUtils.erodingPool(KeyedObjectPool, float) must not allow a null pool.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((KeyedObjectPool)null, (float)1.0f, (boolean)true), (String)"PoolUtils.erodingPool(KeyedObjectPool, float, boolean) must not allow a null pool.");
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)0.0f), (String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a non-positive factor.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)0.0f, (boolean)false), (String)"PoolUtils.erodingPool(ObjectPool, float, boolean) must not allow a non-positive factor.");
        float factor = 0.01f;
        ArrayList<String> expectedMethods = new ArrayList<String>();
        try (KeyedObjectPool pool = PoolUtils.erodingPool((KeyedObjectPool)TestPoolUtils.createProxy(KeyedObjectPool.class, handler), (float)0.01f);){
            Assertions.assertEquals(expectedMethods, calledMethods);
            String key = "key";
            pool.addObject((Object)key);
            expectedMethods.add("addObject");
            Object o = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            Assertions.assertEquals(expectedMethods, calledMethods);
            pool.returnObject((Object)key, o);
            expectedMethods.add("returnObject");
            Assertions.assertEquals(expectedMethods, calledMethods);
            Assertions.assertEquals((int)1, (int)pool.getNumActive());
            expectedMethods.add("getNumActive");
            Assertions.assertEquals((int)1, (int)pool.getNumIdle());
            expectedMethods.add("getNumIdle");
            for (int i = 0; i < 5; ++i) {
                o = pool.borrowObject((Object)key);
                expectedMethods.add("borrowObject");
                Thread.sleep(50L);
                pool.returnObject((Object)key, o);
                expectedMethods.add("returnObject");
                Assertions.assertEquals(expectedMethods, calledMethods);
                expectedMethods.clear();
                calledMethods.clear();
            }
            Thread.sleep(10000L);
            o = pool.borrowObject((Object)key);
            expectedMethods.add("borrowObject");
            pool.returnObject((Object)key, o);
            expectedMethods.add("getNumIdle");
            expectedMethods.add("invalidateObject");
            pool.clear();
        }
        expectedMethods.add("clear");
        expectedMethods.add("close");
        Assertions.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    void testErodingPoolKeyedObjectPoolDefaultFactor() {
        try (KeyedObjectPool internalPool = TestPoolUtils.createProxy(KeyedObjectPool.class, (Object arg0, Method arg1, Object[] arg2) -> null);
             KeyedObjectPool pool = PoolUtils.erodingPool((KeyedObjectPool)internalPool);){
            String expectedToString = "ErodingKeyedObjectPool{factor=ErodingFactor{factor=1.0, idleHighWaterMark=1}, keyedPool=" + internalPool + "}";
            Assertions.assertEquals((Object)expectedToString, (Object)pool.toString());
        }
    }

    @Test
    void testErodingPoolObjectPool() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((ObjectPool)null), (String)"PoolUtils.erodingPool(ObjectPool) must not allow a null pool.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((ObjectPool)null, (float)1.0f), (String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a null pool.");
        ArrayList calledMethods = new ArrayList();
        MethodCallLogger handler = new MethodCallLogger(calledMethods){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object o = super.invoke(proxy, method, args);
                if (o instanceof Integer) {
                    o = 1;
                }
                return o;
            }
        };
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.erodingPool((ObjectPool)TestPoolUtils.createProxy(ObjectPool.class, handler), (float)-1.0f), (String)"PoolUtils.erodingPool(ObjectPool, float) must not allow a non-positive factor.");
        float factor = 0.01f;
        ArrayList<String> expectedMethods = new ArrayList<String>();
        try (ObjectPool pool = PoolUtils.erodingPool((ObjectPool)TestPoolUtils.createProxy(ObjectPool.class, handler), (float)0.01f);){
            Assertions.assertEquals(expectedMethods, calledMethods);
            pool.addObject();
            expectedMethods.add("addObject");
            Object o = pool.borrowObject();
            expectedMethods.add("borrowObject");
            Assertions.assertEquals(expectedMethods, calledMethods);
            pool.returnObject(o);
            expectedMethods.add("returnObject");
            Assertions.assertEquals(expectedMethods, calledMethods);
            Assertions.assertEquals((int)1, (int)pool.getNumActive());
            expectedMethods.add("getNumActive");
            Assertions.assertEquals((int)1, (int)pool.getNumIdle());
            expectedMethods.add("getNumIdle");
            for (int i = 0; i < 5; ++i) {
                o = pool.borrowObject();
                expectedMethods.add("borrowObject");
                Thread.sleep(50L);
                pool.returnObject(o);
                expectedMethods.add("returnObject");
                Assertions.assertEquals(expectedMethods, calledMethods);
                expectedMethods.clear();
                calledMethods.clear();
            }
            Thread.sleep(10000L);
            o = pool.borrowObject();
            expectedMethods.add("borrowObject");
            pool.returnObject(o);
            expectedMethods.add("getNumIdle");
            expectedMethods.add("invalidateObject");
            pool.clear();
        }
        expectedMethods.add("clear");
        expectedMethods.add("close");
        Assertions.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    void testJavaBeanInstantiation() {
        Assertions.assertNotNull((Object)new PoolUtils());
    }

    @Test
    void testPrefillKeyedObjectPool() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.prefill(null, (Object)new Object(), (int)1), (String)"PoolUtils.prefill(KeyedObjectPool,Object,int) must not accept null pool.");
        try (GenericKeyedObjectPool pool = new GenericKeyedObjectPool(new TestGenericKeyedObjectPool.SimpleFactory());){
            Assertions.assertThrows(IllegalArgumentException.class, () -> TestPoolUtils.lambda$testPrefillKeyedObjectPool$20((KeyedObjectPool)pool), (String)"PoolUtils.prefill(KeyedObjectPool,Object,int) must not accept null key.");
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);){
            PoolUtils.prefill((KeyedObjectPool)pool, (Object)new Object(), (int)0);
            ArrayList<String> expectedMethods = new ArrayList<String>();
            expectedMethods.add("addObjects");
            Assertions.assertEquals(expectedMethods, calledMethods);
            calledMethods.clear();
            PoolUtils.prefill((KeyedObjectPool)pool, (Object)new Object(), (int)3);
            Assertions.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    void testPrefillKeyedObjectPoolCollection() throws Exception {
        try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, (List<String>)null);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.prefill((KeyedObjectPool)pool, (Collection)null, (int)1), (String)"PoolUtils.prefill(KeyedObjectPool,Collection,int) must not accept null keys.");
        }
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (KeyedObjectPool pool = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);){
            HashSet<String> keys = new HashSet<String>();
            PoolUtils.prefill((KeyedObjectPool)pool, keys, (int)0);
            ArrayList<String> expectedMethods = new ArrayList<String>();
            expectedMethods.add("addObjects");
            Assertions.assertEquals(expectedMethods, calledMethods);
            calledMethods.clear();
            keys.add("one");
            keys.add("two");
            keys.add("three");
            int count = 3;
            PoolUtils.prefill((KeyedObjectPool)pool, keys, (int)3);
            Assertions.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    void testPrefillObjectPool() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.prefill(null, (int)1), (String)"PoolUtils.prefill(ObjectPool,int) must not allow null pool.");
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (ObjectPool pool = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);){
            PoolUtils.prefill((ObjectPool)pool, (int)0);
            ArrayList<String> expectedMethods = new ArrayList<String>();
            expectedMethods.add("addObjects");
            Assertions.assertEquals(expectedMethods, calledMethods);
            calledMethods.clear();
            PoolUtils.prefill((ObjectPool)pool, (int)3);
            Assertions.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    void testSynchronizedPoolableFactoryKeyedPooledObjectFactory() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.synchronizedKeyedPooledFactory((KeyedPooledObjectFactory)null), (String)"PoolUtils.synchronizedPoolableFactory(KeyedPooledObjectFactory) must not allow a null factory.");
        ArrayList<String> calledMethods = new ArrayList<String>();
        KeyedPooledObjectFactory kpof = TestPoolUtils.createProxy(KeyedPooledObjectFactory.class, calledMethods);
        KeyedPooledObjectFactory skpof = PoolUtils.synchronizedKeyedPooledFactory((KeyedPooledObjectFactory)kpof);
        List<String> expectedMethods = TestPoolUtils.invokeEveryMethod(skpof);
        Assertions.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    void testSynchronizedPoolableFactoryPoolableObjectFactory() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.synchronizedPooledFactory((PooledObjectFactory)null), (String)"PoolUtils.synchronizedPoolableFactory(PoolableObjectFactory) must not allow a null factory.");
        ArrayList<String> calledMethods = new ArrayList<String>();
        PooledObjectFactory pof = TestPoolUtils.createProxy(PooledObjectFactory.class, calledMethods);
        PooledObjectFactory spof = PoolUtils.synchronizedPooledFactory((PooledObjectFactory)pof);
        List<String> expectedMethods = TestPoolUtils.invokeEveryMethod(spof);
        Assertions.assertEquals(expectedMethods, calledMethods);
    }

    @Test
    void testSynchronizedPoolKeyedObjectPool() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.synchronizedPool((KeyedObjectPool)null), (String)"PoolUtils.synchronizedPool(KeyedObjectPool) must not allow a null pool.");
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (KeyedObjectPool kop = TestPoolUtils.createProxy(KeyedObjectPool.class, calledMethods);
             KeyedObjectPool skop = PoolUtils.synchronizedPool((KeyedObjectPool)kop);){
            List<String> expectedMethods = TestPoolUtils.invokeEveryMethod((KeyedObjectPool<Object, Object>)skop);
            Assertions.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    void testSynchronizedPoolObjectPool() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PoolUtils.synchronizedPool((ObjectPool)null), (String)"PoolUtils.synchronizedPool(ObjectPool) must not allow a null pool.");
        ArrayList<String> calledMethods = new ArrayList<String>();
        try (ObjectPool op = TestPoolUtils.createProxy(ObjectPool.class, calledMethods);
             ObjectPool sop = PoolUtils.synchronizedPool((ObjectPool)op);){
            List<String> expectedMethods = TestPoolUtils.invokeEveryMethod((ObjectPool<Object>)sop);
            Assertions.assertEquals(expectedMethods, calledMethods);
        }
    }

    @Test
    void testTimerHolder() {
        PoolUtils.TimerHolder h = new PoolUtils.TimerHolder();
        Assertions.assertNotNull((Object)h);
        Assertions.assertNotNull((Object)PoolUtils.TimerHolder.MIN_IDLE_TIMER);
    }

    private static /* synthetic */ void lambda$testPrefillKeyedObjectPool$20(KeyedObjectPool pool) throws Throwable {
        PoolUtils.prefill((KeyedObjectPool)pool, null, (int)1);
    }

    private static class MethodCallLogger
    implements InvocationHandler {
        private final List<String> calledMethods;

        MethodCallLogger(List<String> calledMethods) {
            this.calledMethods = calledMethods;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.calledMethods == null) {
                return null;
            }
            this.calledMethods.add(method.getName());
            if (Boolean.TYPE.equals(method.getReturnType())) {
                return Boolean.FALSE;
            }
            if (Integer.TYPE.equals(method.getReturnType())) {
                return 0;
            }
            if (Long.TYPE.equals(method.getReturnType())) {
                return 0L;
            }
            if (Object.class.equals(method.getReturnType())) {
                return new Object();
            }
            if (PooledObject.class.equals(method.getReturnType())) {
                return new DefaultPooledObject(new Object());
            }
            return null;
        }
    }
}

