/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegratorAbstractTest;
import org.apache.commons.math3.ode.nonstiff.HighamHall54FieldIntegrator;
import org.apache.commons.math3.util.Decimal64Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighamHall54FieldIntegratorTest
extends EmbeddedRungeKuttaFieldIntegratorAbstractTest {
    @Override
    protected <T extends RealFieldElement<T>> EmbeddedRungeKuttaFieldIntegrator<T> createIntegrator(Field<T> field, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        return new HighamHall54FieldIntegrator(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    @Override
    protected <T extends RealFieldElement<T>> EmbeddedRungeKuttaFieldIntegrator<T> createIntegrator(Field<T> field, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        return new HighamHall54FieldIntegrator(field, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    public void testNonFieldIntegratorConsistency() {
        this.doTestNonFieldIntegratorConsistency(Decimal64Field.getInstance());
    }

    @Override
    public void testSanityChecks() {
        this.doTestSanityChecks(Decimal64Field.getInstance());
    }

    @Override
    public void testBackward() {
        this.doTestBackward(Decimal64Field.getInstance(), 5.0E-7, 5.0E-7, 1.0E-12, "Higham-Hall 5(4)");
    }

    @Override
    public void testKepler() {
        this.doTestKepler(Decimal64Field.getInstance(), 1.5E-4);
    }

    @Override
    public void testForwardBackwardExceptions() {
        this.doTestForwardBackwardExceptions(Decimal64Field.getInstance());
    }

    @Override
    public void testMinStep() {
        this.doTestMinStep(Decimal64Field.getInstance());
    }

    @Override
    public void testIncreasingTolerance() {
        this.doTestIncreasingTolerance(Decimal64Field.getInstance(), 1.3, 1.0E-12);
    }

    @Override
    public void testEvents() {
        this.doTestEvents(Decimal64Field.getInstance(), 1.0E-7, "Higham-Hall 5(4)");
    }

    @Override
    public void testEventsErrors() {
        this.doTestEventsErrors(Decimal64Field.getInstance());
    }

    @Override
    public void testEventsNoConvergence() {
        this.doTestEventsNoConvergence(Decimal64Field.getInstance());
    }

    @Override
    public void testPartialDerivatives() {
        this.doTestPartialDerivatives(1.2E-11, new double[]{6.4E-11, 1.8E-11, 2.4E-12, 2.2E-12, 1.8E-11});
    }
}

