/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.Random;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RRQRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.junit.Assert;
import org.junit.Test;

public class RRQRDecompositionTest {
    private double[][] testData3x3NonSingular = new double[][]{{12.0, -51.0, 4.0}, {6.0, 167.0, -68.0}, {-4.0, 24.0, -41.0}};
    private double[][] testData3x3Singular = new double[][]{{1.0, 4.0, 7.0}, {2.0, 5.0, 8.0}, {3.0, 6.0, 9.0}};
    private double[][] testData3x4 = new double[][]{{12.0, -51.0, 4.0, 1.0}, {6.0, 167.0, -68.0, 2.0}, {-4.0, 24.0, -41.0, 3.0}};
    private double[][] testData4x3 = new double[][]{{12.0, -51.0, 4.0}, {6.0, 167.0, -68.0}, {-4.0, 24.0, -41.0}, {-5.0, 34.0, 7.0}};
    private static final double entryTolerance = 1.0E-15;
    private static final double normTolerance = 1.0E-13;

    @Test
    public void testDimensions() {
        this.checkDimension(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular));
        this.checkDimension(MatrixUtils.createRealMatrix((double[][])this.testData4x3));
        this.checkDimension(MatrixUtils.createRealMatrix((double[][])this.testData3x4));
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        this.checkDimension(this.createTestMatrix(r, p, q));
        this.checkDimension(this.createTestMatrix(r, q, p));
    }

    private void checkDimension(RealMatrix m) {
        int rows = m.getRowDimension();
        int columns = m.getColumnDimension();
        RRQRDecomposition qr = new RRQRDecomposition(m);
        Assert.assertEquals((long)rows, (long)qr.getQ().getRowDimension());
        Assert.assertEquals((long)rows, (long)qr.getQ().getColumnDimension());
        Assert.assertEquals((long)rows, (long)qr.getR().getRowDimension());
        Assert.assertEquals((long)columns, (long)qr.getR().getColumnDimension());
    }

    @Test
    public void testAPEqualQR() {
        this.checkAPEqualQR(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular));
        this.checkAPEqualQR(MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular));
        this.checkAPEqualQR(MatrixUtils.createRealMatrix((double[][])this.testData3x4));
        this.checkAPEqualQR(MatrixUtils.createRealMatrix((double[][])this.testData4x3));
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        this.checkAPEqualQR(this.createTestMatrix(r, p, q));
        this.checkAPEqualQR(this.createTestMatrix(r, q, p));
    }

    private void checkAPEqualQR(RealMatrix m) {
        RRQRDecomposition rrqr = new RRQRDecomposition(m);
        double norm = rrqr.getQ().multiply(rrqr.getR()).subtract(m.multiply(rrqr.getP())).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
    }

    @Test
    public void testQOrthogonal() {
        this.checkQOrthogonal(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular));
        this.checkQOrthogonal(MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular));
        this.checkQOrthogonal(MatrixUtils.createRealMatrix((double[][])this.testData3x4));
        this.checkQOrthogonal(MatrixUtils.createRealMatrix((double[][])this.testData4x3));
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        this.checkQOrthogonal(this.createTestMatrix(r, p, q));
        this.checkQOrthogonal(this.createTestMatrix(r, q, p));
    }

    private void checkQOrthogonal(RealMatrix m) {
        RRQRDecomposition qr = new RRQRDecomposition(m);
        RealMatrix eye = MatrixUtils.createRealIdentityMatrix((int)m.getRowDimension());
        double norm = qr.getQT().multiply(qr.getQ()).subtract(eye).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-13);
    }

    @Test
    public void testRUpperTriangular() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular);
        this.checkUpperTriangular(new RRQRDecomposition(matrix).getR());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular);
        this.checkUpperTriangular(new RRQRDecomposition(matrix).getR());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x4);
        this.checkUpperTriangular(new RRQRDecomposition(matrix).getR());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData4x3);
        this.checkUpperTriangular(new RRQRDecomposition(matrix).getR());
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        matrix = this.createTestMatrix(r, p, q);
        this.checkUpperTriangular(new RRQRDecomposition(matrix).getR());
        matrix = this.createTestMatrix(r, p, q);
        this.checkUpperTriangular(new RRQRDecomposition(matrix).getR());
    }

    private void checkUpperTriangular(RealMatrix m) {
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                if (column < row) {
                    Assert.assertEquals((double)0.0, (double)value, (double)1.0E-15);
                }
            }
        });
    }

    @Test
    public void testHTrapezoidal() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular);
        this.checkTrapezoidal(new RRQRDecomposition(matrix).getH());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular);
        this.checkTrapezoidal(new RRQRDecomposition(matrix).getH());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData3x4);
        this.checkTrapezoidal(new RRQRDecomposition(matrix).getH());
        matrix = MatrixUtils.createRealMatrix((double[][])this.testData4x3);
        this.checkTrapezoidal(new RRQRDecomposition(matrix).getH());
        Random r = new Random(643895747384642L);
        int p = 65;
        int q = 91;
        matrix = this.createTestMatrix(r, p, q);
        this.checkTrapezoidal(new RRQRDecomposition(matrix).getH());
        matrix = this.createTestMatrix(r, p, q);
        this.checkTrapezoidal(new RRQRDecomposition(matrix).getH());
    }

    private void checkTrapezoidal(RealMatrix m) {
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)new DefaultRealMatrixPreservingVisitor(){

            public void visit(int row, int column, double value) {
                if (column > row) {
                    Assert.assertEquals((double)0.0, (double)value, (double)1.0E-15);
                }
            }
        });
    }

    @Test(expected=SingularMatrixException.class)
    public void testNonInvertible() {
        RRQRDecomposition qr = new RRQRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular), 3.0E-16);
        qr.getSolver().getInverse();
    }

    private RealMatrix createTestMatrix(final Random r, int rows, int columns) {
        RealMatrix m = MatrixUtils.createRealMatrix((int)rows, (int)columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int column, double value) {
                return 2.0 * r.nextDouble() - 1.0;
            }
        });
        return m;
    }

    @Test
    public void testRank() {
        double[][] d = new double[][]{{1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {1.0, 2.0, 3.0}};
        Array2DRowRealMatrix m = new Array2DRowRealMatrix((double[][])d);
        RRQRDecomposition qr = new RRQRDecomposition((RealMatrix)m);
        Assert.assertEquals((long)2L, (long)qr.getRank(1.0E-16));
    }
}

