/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.geometry.euclidean.threed;

import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class LineTest {
    @Test
    public void testContains() throws MathIllegalArgumentException, MathArithmeticException {
        Vector3D p1 = new Vector3D(0.0, 0.0, 1.0);
        Line l = new Line(p1, new Vector3D(0.0, 0.0, 2.0), 1.0E-10);
        Assert.assertTrue((boolean)l.contains(p1));
        Assert.assertTrue((boolean)l.contains(new Vector3D(1.0, p1, 0.3, l.getDirection())));
        Vector3D u = l.getDirection().orthogonal();
        Vector3D v = Vector3D.crossProduct((Vector3D)l.getDirection(), (Vector3D)u);
        for (double alpha = 0.0; alpha < Math.PI * 2; alpha += 0.3) {
            Assert.assertTrue((!l.contains(p1.add((Vector)new Vector3D(FastMath.cos((double)alpha), u, FastMath.sin((double)alpha), v))) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSimilar() throws MathIllegalArgumentException, MathArithmeticException {
        Vector3D p1 = new Vector3D(1.2, 3.4, -5.8);
        Vector3D p2 = new Vector3D(3.4, -5.8, 1.2);
        Line lA = new Line(p1, p2, 1.0E-10);
        Line lB = new Line(p2, p1, 1.0E-10);
        Assert.assertTrue((boolean)lA.isSimilarTo(lB));
        Assert.assertTrue((!lA.isSimilarTo(new Line(p1, p1.add((Vector)lA.getDirection().orthogonal()), 1.0E-10)) ? 1 : 0) != 0);
    }

    @Test
    public void testPointDistance() throws MathIllegalArgumentException {
        Line l = new Line(new Vector3D(0.0, 1.0, 1.0), new Vector3D(0.0, 2.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)1.5), (double)l.distance(new Vector3D(1.0, 0.0, 1.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.distance(new Vector3D(0.0, -4.0, -4.0)), (double)1.0E-10);
    }

    @Test
    public void testLineDistance() throws MathIllegalArgumentException {
        Line l = new Line(new Vector3D(0.0, 1.0, 1.0), new Vector3D(0.0, 2.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)1.0, (double)l.distance(new Line(new Vector3D(1.0, 0.0, 1.0), new Vector3D(1.0, 0.0, 2.0), 1.0E-10)), (double)1.0E-10);
        Assert.assertEquals((double)0.5, (double)l.distance(new Line(new Vector3D(-0.5, 0.0, 0.0), new Vector3D(-0.5, -1.0, -1.0), 1.0E-10)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.distance(l), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.distance(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(0.0, -5.0, -5.0), 1.0E-10)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.distance(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(0.0, -3.0, -4.0), 1.0E-10)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.distance(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(1.0, -4.0, -4.0), 1.0E-10)), (double)1.0E-10);
        Assert.assertEquals((double)FastMath.sqrt((double)8.0), (double)l.distance(new Line(new Vector3D(0.0, -4.0, 0.0), new Vector3D(1.0, -4.0, 0.0), 1.0E-10)), (double)1.0E-10);
    }

    @Test
    public void testClosest() throws MathIllegalArgumentException {
        Line l = new Line(new Vector3D(0.0, 1.0, 1.0), new Vector3D(0.0, 2.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.closestPoint(new Line(new Vector3D(1.0, 0.0, 1.0), new Vector3D(1.0, 0.0, 2.0), 1.0E-10)).distance((Vector)new Vector3D(0.0, 0.0, 0.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.5, (double)l.closestPoint(new Line(new Vector3D(-0.5, 0.0, 0.0), new Vector3D(-0.5, -1.0, -1.0), 1.0E-10)).distance((Vector)new Vector3D(-0.5, 0.0, 0.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.closestPoint(l).distance((Vector)new Vector3D(0.0, 0.0, 0.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.closestPoint(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(0.0, -5.0, -5.0), 1.0E-10)).distance((Vector)new Vector3D(0.0, 0.0, 0.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.closestPoint(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(0.0, -3.0, -4.0), 1.0E-10)).distance((Vector)new Vector3D(0.0, -4.0, -4.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.closestPoint(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(1.0, -4.0, -4.0), 1.0E-10)).distance((Vector)new Vector3D(0.0, -4.0, -4.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.closestPoint(new Line(new Vector3D(0.0, -4.0, 0.0), new Vector3D(1.0, -4.0, 0.0), 1.0E-10)).distance((Vector)new Vector3D(0.0, -2.0, -2.0)), (double)1.0E-10);
    }

    @Test
    public void testIntersection() throws MathIllegalArgumentException {
        Line l = new Line(new Vector3D(0.0, 1.0, 1.0), new Vector3D(0.0, 2.0, 2.0), 1.0E-10);
        Assert.assertNull((Object)l.intersection(new Line(new Vector3D(1.0, 0.0, 1.0), new Vector3D(1.0, 0.0, 2.0), 1.0E-10)));
        Assert.assertNull((Object)l.intersection(new Line(new Vector3D(-0.5, 0.0, 0.0), new Vector3D(-0.5, -1.0, -1.0), 1.0E-10)));
        Assert.assertEquals((double)0.0, (double)l.intersection(l).distance((Vector)new Vector3D(0.0, 0.0, 0.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.intersection(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(0.0, -5.0, -5.0), 1.0E-10)).distance((Vector)new Vector3D(0.0, 0.0, 0.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.intersection(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(0.0, -3.0, -4.0), 1.0E-10)).distance((Vector)new Vector3D(0.0, -4.0, -4.0)), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)l.intersection(new Line(new Vector3D(0.0, -4.0, -4.0), new Vector3D(1.0, -4.0, -4.0), 1.0E-10)).distance((Vector)new Vector3D(0.0, -4.0, -4.0)), (double)1.0E-10);
        Assert.assertNull((Object)l.intersection(new Line(new Vector3D(0.0, -4.0, 0.0), new Vector3D(1.0, -4.0, 0.0), 1.0E-10)));
    }

    @Test
    public void testRevert() {
        Line line = new Line(new Vector3D(1653345.6696423641, 6170370.041579291, 90000.0), new Vector3D(1650757.5050732433, 6160710.879908984, 0.9), 1.0E-10);
        Vector3D expected = line.getDirection().negate();
        Line reverted = line.revert();
        Assert.assertArrayEquals((double[])expected.toArray(), (double[])reverted.getDirection().toArray(), (double)0.0);
    }
}

