/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.IntegerDistribution;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.util.FastMath;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class IntegerDistributionAbstractTest {
    private IntegerDistribution distribution;
    private double tolerance = 1.0E-12;
    private int[] densityTestPoints;
    private double[] densityTestValues;
    private double[] logDensityTestValues;
    private int[] cumulativeTestPoints;
    private double[] cumulativeTestValues;
    private double[] inverseCumulativeTestPoints;
    private int[] inverseCumulativeTestValues;

    public abstract IntegerDistribution makeDistribution();

    public abstract int[] makeDensityTestPoints();

    public abstract double[] makeDensityTestValues();

    public double[] makeLogDensityTestValues() {
        double[] densityTestValues = this.makeDensityTestValues();
        double[] logDensityTestValues = new double[densityTestValues.length];
        for (int i = 0; i < densityTestValues.length; ++i) {
            logDensityTestValues[i] = FastMath.log((double)densityTestValues[i]);
        }
        return logDensityTestValues;
    }

    public abstract int[] makeCumulativeTestPoints();

    public abstract double[] makeCumulativeTestValues();

    public abstract double[] makeInverseCumulativeTestPoints();

    public abstract int[] makeInverseCumulativeTestValues();

    @Before
    public void setUp() {
        this.distribution = this.makeDistribution();
        this.densityTestPoints = this.makeDensityTestPoints();
        this.densityTestValues = this.makeDensityTestValues();
        this.logDensityTestValues = this.makeLogDensityTestValues();
        this.cumulativeTestPoints = this.makeCumulativeTestPoints();
        this.cumulativeTestValues = this.makeCumulativeTestValues();
        this.inverseCumulativeTestPoints = this.makeInverseCumulativeTestPoints();
        this.inverseCumulativeTestValues = this.makeInverseCumulativeTestValues();
    }

    @After
    public void tearDown() {
        this.distribution = null;
        this.densityTestPoints = null;
        this.densityTestValues = null;
        this.logDensityTestValues = null;
        this.cumulativeTestPoints = null;
        this.cumulativeTestValues = null;
        this.inverseCumulativeTestPoints = null;
        this.inverseCumulativeTestValues = null;
    }

    protected void verifyDensities() {
        for (int i = 0; i < this.densityTestPoints.length; ++i) {
            Assert.assertEquals((String)("Incorrect density value returned for " + this.densityTestPoints[i]), (double)this.densityTestValues[i], (double)this.distribution.probability(this.densityTestPoints[i]), (double)this.getTolerance());
        }
    }

    protected void verifyLogDensities() {
        for (int i = 0; i < this.densityTestPoints.length; ++i) {
            Assert.assertEquals((String)("Incorrect log density value returned for " + this.densityTestPoints[i]), (double)this.logDensityTestValues[i], (double)((AbstractIntegerDistribution)this.distribution).logProbability(this.densityTestPoints[i]), (double)this.tolerance);
        }
    }

    protected void verifyCumulativeProbabilities() {
        for (int i = 0; i < this.cumulativeTestPoints.length; ++i) {
            Assert.assertEquals((String)("Incorrect cumulative probability value returned for " + this.cumulativeTestPoints[i]), (double)this.cumulativeTestValues[i], (double)this.distribution.cumulativeProbability(this.cumulativeTestPoints[i]), (double)this.getTolerance());
        }
    }

    protected void verifyInverseCumulativeProbabilities() {
        for (int i = 0; i < this.inverseCumulativeTestPoints.length; ++i) {
            Assert.assertEquals((String)("Incorrect inverse cumulative probability value returned for " + this.inverseCumulativeTestPoints[i]), (long)this.inverseCumulativeTestValues[i], (long)this.distribution.inverseCumulativeProbability(this.inverseCumulativeTestPoints[i]));
        }
    }

    @Test
    public void testDensities() {
        this.verifyDensities();
    }

    @Test
    public void testLogDensities() {
        this.verifyLogDensities();
    }

    @Test
    public void testCumulativeProbabilities() {
        this.verifyCumulativeProbabilities();
    }

    @Test
    public void testInverseCumulativeProbabilities() {
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testConsistencyAtSupportBounds() {
        int lower = this.distribution.getSupportLowerBound();
        Assert.assertEquals((String)"Cumulative probability mmust be 0 below support lower bound.", (double)0.0, (double)this.distribution.cumulativeProbability(lower - 1), (double)0.0);
        Assert.assertEquals((String)"Cumulative probability of support lower bound must be equal to probability mass at this point.", (double)this.distribution.probability(lower), (double)this.distribution.cumulativeProbability(lower), (double)this.getTolerance());
        Assert.assertEquals((String)"Inverse cumulative probability of 0 must be equal to support lower bound.", (long)lower, (long)this.distribution.inverseCumulativeProbability(0.0));
        int upper = this.distribution.getSupportUpperBound();
        if (upper != Integer.MAX_VALUE) {
            Assert.assertEquals((String)"Cumulative probability of support upper bound must be equal to 1.", (double)1.0, (double)this.distribution.cumulativeProbability(upper), (double)0.0);
        }
        Assert.assertEquals((String)"Inverse cumulative probability of 1 must be equal to support upper bound.", (long)upper, (long)this.distribution.inverseCumulativeProbability(1.0));
    }

    @Test
    public void testIllegalArguments() {
        try {
            this.distribution.cumulativeProbability(1, 0);
            Assert.fail((String)"Expecting MathIllegalArgumentException for bad cumulativeProbability interval");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.distribution.inverseCumulativeProbability(-1.0);
            Assert.fail((String)"Expecting MathIllegalArgumentException for p = -1");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.distribution.inverseCumulativeProbability(2.0);
            Assert.fail((String)"Expecting MathIllegalArgumentException for p = 2");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSampling() {
        int[] densityPoints = this.makeDensityTestPoints();
        double[] densityValues = this.makeDensityTestValues();
        int sampleSize = 1000;
        int length = TestUtils.eliminateZeroMassPoints(densityPoints, densityValues);
        AbstractIntegerDistribution distribution = (AbstractIntegerDistribution)this.makeDistribution();
        double[] expectedCounts = new double[length];
        long[] observedCounts = new long[length];
        for (int i = 0; i < length; ++i) {
            expectedCounts[i] = (double)sampleSize * densityValues[i];
        }
        distribution.reseedRandomGenerator(1000L);
        int[] sample = distribution.sample(sampleSize);
        for (int i = 0; i < sampleSize; ++i) {
            for (int j = 0; j < length; ++j) {
                if (sample[i] != densityPoints[j]) continue;
                int n = j;
                observedCounts[n] = observedCounts[n] + 1L;
            }
        }
        TestUtils.assertChiSquareAccept(densityPoints, expectedCounts, observedCounts, 0.001);
    }

    protected int[] getCumulativeTestPoints() {
        return this.cumulativeTestPoints;
    }

    protected void setCumulativeTestPoints(int[] cumulativeTestPoints) {
        this.cumulativeTestPoints = cumulativeTestPoints;
    }

    protected double[] getCumulativeTestValues() {
        return this.cumulativeTestValues;
    }

    protected void setCumulativeTestValues(double[] cumulativeTestValues) {
        this.cumulativeTestValues = cumulativeTestValues;
    }

    protected int[] getDensityTestPoints() {
        return this.densityTestPoints;
    }

    protected void setDensityTestPoints(int[] densityTestPoints) {
        this.densityTestPoints = densityTestPoints;
    }

    protected double[] getDensityTestValues() {
        return this.densityTestValues;
    }

    protected void setDensityTestValues(double[] densityTestValues) {
        this.densityTestValues = densityTestValues;
    }

    protected IntegerDistribution getDistribution() {
        return this.distribution;
    }

    protected void setDistribution(IntegerDistribution distribution) {
        this.distribution = distribution;
    }

    protected double[] getInverseCumulativeTestPoints() {
        return this.inverseCumulativeTestPoints;
    }

    protected void setInverseCumulativeTestPoints(double[] inverseCumulativeTestPoints) {
        this.inverseCumulativeTestPoints = inverseCumulativeTestPoints;
    }

    protected int[] getInverseCumulativeTestValues() {
        return this.inverseCumulativeTestValues;
    }

    protected void setInverseCumulativeTestValues(int[] inverseCumulativeTestValues) {
        this.inverseCumulativeTestValues = inverseCumulativeTestValues;
    }

    protected double getTolerance() {
        return this.tolerance;
    }

    protected void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }
}

