/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.exec.util.MapUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MapUtilTest {
    MapUtilTest() {
    }

    @Test
    void testCopyMap() throws Exception {
        HashMap<String, String> procEnvironment = new HashMap<String, String>();
        procEnvironment.put("JAVA_HOME", "/usr/opt/java");
        Map result = MapUtils.copy(procEnvironment);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((int)1, (int)procEnvironment.size());
        Assertions.assertEquals((Object)"/usr/opt/java", result.get("JAVA_HOME"));
        result.remove("JAVA_HOME");
        Assertions.assertTrue((boolean)result.isEmpty());
        Assertions.assertEquals((int)1, (int)procEnvironment.size());
    }

    @Test
    void testMergeMap() throws Exception {
        Map procEnvironment = EnvironmentUtils.getProcEnvironment();
        HashMap<String, String> applicationEnvironment = new HashMap<String, String>();
        applicationEnvironment.put("appMainClass", "foo.bar.Main");
        Map result = MapUtils.merge((Map)procEnvironment, applicationEnvironment);
        Assertions.assertEquals((int)(procEnvironment.size() + applicationEnvironment.size()), (int)result.size());
        Assertions.assertEquals((Object)"foo.bar.Main", result.get("appMainClass"));
    }

    @Test
    void testPrefixMap() throws Exception {
        HashMap<String, String> procEnvironment = new HashMap<String, String>();
        procEnvironment.put("JAVA_HOME", "/usr/opt/java");
        Map result = MapUtils.prefix(procEnvironment, (String)"env");
        Assertions.assertEquals((int)procEnvironment.size(), (int)result.size());
        Assertions.assertEquals((Object)"/usr/opt/java", result.get("env.JAVA_HOME"));
    }
}

