/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.validation;

import java.util.EnumSet;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.cayenne.configuration.event.DomainEvent;
import org.apache.cayenne.configuration.event.DomainListener;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.UpdateValidationConfigAction;
import org.apache.cayenne.modeler.editor.validation.ValidationTab;
import org.apache.cayenne.modeler.event.ValidationConfigDisplayEvent;
import org.apache.cayenne.modeler.event.ValidationConfigDisplayListener;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;
import org.apache.cayenne.swing.components.tree.CheckBoxNodeData;

public class ValidationTabController
implements DomainListener,
ValidationConfigDisplayListener {
    private final ProjectController projectController;
    private final DataChannelMetaData metaData;
    private final ValidationTab view;
    private Set<Inspection> enabledInspections;
    private InspectionTreeModelListener inspectionTreeModelListener;

    public ValidationTabController(ProjectController projectController) {
        this.projectController = projectController;
        this.metaData = projectController.getApplication().getInjector().getInstance(DataChannelMetaData.class);
        this.view = new ValidationTab(this);
    }

    @Override
    public void domainChanged(DomainEvent e) {
        this.view.inspectionTree.getModel().removeTreeModelListener(this.inspectionTreeModelListener);
        this.configUpdated(ValidationConfig.fromMetadata(this.metaData, e.getDomain()));
        this.view.inspectionTree.getModel().addTreeModelListener(this.inspectionTreeModelListener);
    }

    @Override
    public void validationOptionChanged(ValidationConfigDisplayEvent event) {
        Inspection inspection = event.getInspection();
        if (inspection != null) {
            this.view.inspectionTree.selectInspection(inspection);
        }
    }

    public ValidationTab getView() {
        return this.view;
    }

    void onViewLoaded() {
        this.projectController.addDomainListener(this);
        this.projectController.addValidationConfigDisplayListener(this);
        this.configUpdated(ValidationConfig.fromMetadata(this.metaData, this.projectController.getCurrentDataChanel()));
        this.initListeners();
    }

    private void initListeners() {
        this.inspectionTreeModelListener = new InspectionTreeModelListener();
        this.view.inspectionTree.getModel().addTreeModelListener(this.inspectionTreeModelListener);
    }

    private void configUpdated(ValidationConfig updatedConfig) {
        Set<Inspection> configInspections = updatedConfig.getEnabledInspections();
        this.enabledInspections = configInspections.isEmpty() ? EnumSet.noneOf(Inspection.class) : EnumSet.copyOf(configInspections);
        this.view.inspectionTree.refreshEnabledInspections(this.enabledInspections);
    }

    private class InspectionTreeModelListener
    implements TreeModelListener {
        private InspectionTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.handleEvent(e);
        }

        private void handleEvent(TreeModelEvent e) {
            boolean inspectionsUpdated = false;
            for (Object child : e.getChildren()) {
                CheckBoxNodeData data;
                DefaultMutableTreeNode node;
                if (!(child instanceof DefaultMutableTreeNode) || !((node = (DefaultMutableTreeNode)child).getUserObject() instanceof CheckBoxNodeData) || !((data = (CheckBoxNodeData)node.getUserObject()).getValue() instanceof Inspection)) continue;
                Inspection inspection = (Inspection)((Object)data.getValue());
                inspectionsUpdated = data.isSelected() ? ValidationTabController.this.enabledInspections.add(inspection) : ValidationTabController.this.enabledInspections.remove((Object)inspection);
            }
            if (inspectionsUpdated) {
                ValidationTabController.this.projectController.getApplication().getActionManager().getAction(UpdateValidationConfigAction.class).putConfig(new ValidationConfig(ValidationTabController.this.enabledInspections)).setUndoable(true).performAction(this);
            }
        }
    }
}

