/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.event.ActionEvent;
import java.util.EnumSet;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.UpdateValidationConfigAction;
import org.apache.cayenne.modeler.action.ValidateAction;
import org.apache.cayenne.project.validation.Inspection;
import org.apache.cayenne.project.validation.ValidationConfig;

public class DisableValidationInspectionAction
extends UpdateValidationConfigAction {
    public static final String ACTION_NAME = "Disable inspection";
    private static final String INSPECTION_PARAM = "inspection";
    private final ValidateAction validationAction;

    public DisableValidationInspectionAction(Application application) {
        super(ACTION_NAME, application);
        this.validationAction = new ValidateAction(application);
        this.setUndoable(false);
    }

    @Override
    public void performAction(ActionEvent e) {
        Inspection inspection = (Inspection)((Object)this.getValue(INSPECTION_PARAM));
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.application.getProject().getRootNode();
        ValidationConfig config = ValidationConfig.fromMetadata(this.application.getMetaData(), dataChannel);
        EnumSet<Inspection> enabledInspections = EnumSet.copyOf(config.getEnabledInspections());
        enabledInspections.remove((Object)inspection);
        this.putConfig(new ValidationConfig(enabledInspections));
        super.performAction(e);
        this.validationAction.performAction(e);
    }

    public DisableValidationInspectionAction putInspection(Inspection inspection) {
        this.putValue(INSPECTION_PARAM, (Object)inspection);
        return this;
    }

    @Override
    public String getIconName() {
        return "icon-disable.png";
    }
}

